/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class ResponseDefinitionTransformerAcceptanceTest {
    WireMockServer wm;
    WireMockTestClient client;

    @Test
    public void transformerSpecifiedByClassTransformsHeadersStatusAndBody() {
        this.startWithExtensions("com.github.tomakehurst.wiremock.ResponseDefinitionTransformerAcceptanceTest$ExampleTransformer");
        this.createStub("/to-transform");
        WireMockResponse response = this.client.get("/to-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.firstHeader("MyHeader"), (Matcher)Matchers.is((Object)"Transformed"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Transformed body"));
    }

    @Test
    public void supportsMultipleTransformers() {
        this.startWithExtensions("com.github.tomakehurst.wiremock.ResponseDefinitionTransformerAcceptanceTest$MultiTransformer1", "com.github.tomakehurst.wiremock.ResponseDefinitionTransformerAcceptanceTest$MultiTransformer2");
        this.createStub("/to-multi-transform");
        WireMockResponse response = this.client.get("/to-multi-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Expect this"));
    }

    @Test
    public void supportsSpecifiyingExtensionsByClass() {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Class[]{ExampleTransformer.class, MultiTransformer1.class}));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
        this.createStub("/to-class-transform");
        WireMockResponse response = this.client.get("/to-class-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Transformed body"));
    }

    @Test
    public void supportsSpecifiyingExtensionsByInstance() {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Extension[]{new ExampleTransformer(), new MultiTransformer2()}));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
        this.createStub("/to-instance-transform");
        WireMockResponse response = this.client.get("/to-instance-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Expect this"));
    }

    @Test
    public void doesNotApplyNonGlobalExtensionsWhenNotExplicitlySpecfiedByStub() {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Extension[]{new ExampleTransformer(), new NonGlobalTransformer()}));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
        this.createStub("/non-global-transform");
        WireMockResponse response = this.client.get("/non-global-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Transformed body"));
    }

    @Test
    public void appliesNonGlobalExtensionsWhenSpecifiedByStub() {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Extension[]{new NonGlobalTransformer()}));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/local-transform")).willReturn(WireMock.aResponse().withStatus(200).withBody("Should not see this").withTransformers(new String[]{"local"})));
        WireMockResponse response = this.client.get("/local-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Non-global transformed body"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void preventsMoreThanOneExtensionWithTheSameNameFromBeingAdded() {
        new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Class[]{ExampleTransformer.class, AnotherExampleTransformer.class}));
    }

    @Test
    public void supportsAccessingTheFilesFileSource() {
        this.startWithExtensions("com.github.tomakehurst.wiremock.ResponseDefinitionTransformerAcceptanceTest$FileAccessTransformer");
        this.createStub("/files-access-transform");
        WireMockResponse response = this.client.get("/files-access-transform", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Some example test from a file"));
    }

    @Test
    public void supportsParameters() {
        this.startWithExtensions("com.github.tomakehurst.wiremock.ResponseDefinitionTransformerAcceptanceTest$ParameterisedTransformer");
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/transform-with-params")).willReturn(WireMock.aResponse().withStatus(200).withTransformerParameter("newBody", (Object)"Use this body")));
        MatcherAssert.assertThat((Object)this.client.get("/transform-with-params", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Use this body"));
    }

    private void startWithExtensions(String ... extensions) {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().withRootDirectory(TestFiles.defaultTestFilesRoot()).extensions(extensions));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    @After
    public void cleanup() {
        if (this.wm != null) {
            this.wm.stop();
        }
    }

    private void createStub(String url) {
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withHeader("MyHeader", new String[]{"Initial"}).withStatus(300).withBody("Should not see this")));
    }

    public static class ParameterisedTransformer
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return ResponseDefinitionBuilder.like((ResponseDefinition)responseDefinition).but().withBody(parameters.getString("newBody")).build();
        }

        public String getName() {
            return "params";
        }
    }

    public static class FileAccessTransformer
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return ResponseDefinitionBuilder.like((ResponseDefinition)responseDefinition).but().withBody(files.getBinaryFileNamed("plain-example.txt").readContents()).build();
        }

        public String getName() {
            return "filesource";
        }
    }

    public static class AnotherExampleTransformer
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return responseDefinition;
        }

        public String getName() {
            return "example";
        }
    }

    public static class NonGlobalTransformer
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return ResponseDefinitionBuilder.like((ResponseDefinition)responseDefinition).but().withBody("Non-global transformed body").build();
        }

        public boolean applyGlobally() {
            return false;
        }

        public String getName() {
            return "local";
        }
    }

    public static class MultiTransformer2
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return ResponseDefinitionBuilder.like((ResponseDefinition)responseDefinition).but().withBody("Expect this").build();
        }

        public String getName() {
            return "multi2";
        }
    }

    public static class MultiTransformer1
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return ResponseDefinitionBuilder.like((ResponseDefinition)responseDefinition).but().withStatus(201).build();
        }

        public String getName() {
            return "multi1";
        }
    }

    public static class ExampleTransformer
    extends ResponseDefinitionTransformer {
        public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
            return new ResponseDefinitionBuilder().withHeader("MyHeader", new String[]{"Transformed"}).withStatus(200).withBody("Transformed body").build();
        }

        public String getName() {
            return "example";
        }
    }
}

