/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ResponseDelayAcceptanceTest {
    private static final int SOCKET_TIMEOUT_MILLISECONDS = 500;
    private static final int LONGER_THAN_SOCKET_TIMEOUT = 1000;
    private static final int SHORTER_THAN_SOCKET_TIMEOUT = 250;
    private static final int BRIEF_DELAY_TO_ALLOW_CALL_TO_BE_MADE_MILLISECONDS = 150;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(0, Integer.valueOf(0));
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private HttpClient httpClient;
    private WireMockTestClient testClient;

    @Before
    public void init() {
        this.httpClient = HttpClientFactory.createClient((int)500);
        this.testClient = new WireMockTestClient(this.wireMockRule.port());
    }

    @Test
    public void responseWithFixedDelay() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed/resource")).willReturn(WireMock.aResponse().withStatus(200).withBody("Content").withFixedDelay(Integer.valueOf(500))));
        long start = System.currentTimeMillis();
        this.testClient.get("/delayed/resource", new TestHttpHeader[0]);
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(500)));
    }

    @Test
    public void responseWithByteDribble() {
        byte[] body = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int numberOfChunks = body.length / 2;
        int chunkedDuration = 1000;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/dribble")).willReturn(WireMock.aResponse().withStatus(200).withBody(body).withChunkedDribbleDelay(numberOfChunks, chunkedDuration)));
        long start = System.currentTimeMillis();
        WireMockResponse response = this.testClient.get("/dribble", new TestHttpHeader[0]);
        long timeTaken = System.currentTimeMillis() - start;
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)timeTaken, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(chunkedDuration)));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)response.binaryContent()));
    }

    @Test
    public void responseWithByteDribbleAndFixedDelay() {
        byte[] body = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int numberOfChunks = body.length / 2;
        int fixedDelay = 1000;
        int chunkedDuration = 1000;
        int totalDuration = fixedDelay + chunkedDuration;
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/dribbleWithFixedDelay")).willReturn(WireMock.aResponse().withStatus(200).withBody(body).withChunkedDribbleDelay(numberOfChunks, chunkedDuration).withFixedDelay(Integer.valueOf(fixedDelay))));
        long start = System.currentTimeMillis();
        WireMockResponse response = this.testClient.get("/dribbleWithFixedDelay", new TestHttpHeader[0]);
        long timeTaken = System.currentTimeMillis() - start;
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)timeTaken, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(totalDuration)));
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)response.binaryContent()));
    }

    @Test
    public void responseWithLogNormalDistributedDelay() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/lognormal/delayed/resource")).willReturn(WireMock.aResponse().withStatus(200).withBody("Content").withLogNormalRandomDelay(90.0, 0.1)));
        long start = System.currentTimeMillis();
        this.testClient.get("/lognormal/delayed/resource", new TestHttpHeader[0]);
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(60)));
    }

    @Test
    public void responseWithUniformDistributedDelay() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/uniform/delayed/resource")).willReturn(WireMock.aResponse().withStatus(200).withBody("Content").withUniformRandomDelay(50, 60)));
        long start = System.currentTimeMillis();
        this.testClient.get("/uniform/delayed/resource", new TestHttpHeader[0]);
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(50)));
    }

    @Test
    public void requestTimesOutWhenDelayIsLongerThanSocketTimeout() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(1000))));
        this.exception.expect(SocketTimeoutException.class);
        this.httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://localhost:%d/delayed", this.wireMockRule.port())));
    }

    @Test
    public void requestIsSuccessfulWhenDelayIsShorterThanSocketTimeout() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(250))));
        HttpResponse execute = this.httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://localhost:%d/delayed", this.wireMockRule.port())));
        MatcherAssert.assertThat((Object)execute.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void requestIsRecordedInJournalBeforePerformingDelay() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(250))));
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        AtomicBoolean callSucceeded = this.callDelayedEndpointAsynchronously(executorService);
        Thread.sleep(150L);
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/delayed")));
        executorService.awaitTermination(250L, TimeUnit.MILLISECONDS);
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/delayed")));
        Assert.assertTrue((boolean)callSucceeded.get());
    }

    @Test
    public void inFlightDelayedRequestsAreNotRecordedInJournalAfterReset() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/delayed")).willReturn(WireMock.aResponse().withStatus(200).withFixedDelay(Integer.valueOf(250))));
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        AtomicBoolean callSucceeded = this.callDelayedEndpointAsynchronously(executorService);
        Thread.sleep(150L);
        this.assertExpectedCallCount(1, WireMock.urlEqualTo((String)"/delayed"));
        WireMock.reset();
        executorService.awaitTermination(250L, TimeUnit.MILLISECONDS);
        this.assertExpectedCallCount(0, WireMock.urlEqualTo((String)"/delayed"));
        Assert.assertTrue((boolean)callSucceeded.get());
    }

    private AtomicBoolean callDelayedEndpointAsynchronously(ExecutorService executorService) {
        final AtomicBoolean success = new AtomicBoolean(false);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpGet request = new HttpGet(String.format("http://localhost:%d/delayed", ResponseDelayAcceptanceTest.this.wireMockRule.port()));
                    HttpResponse execute = ResponseDelayAcceptanceTest.this.httpClient.execute((HttpUriRequest)request);
                    MatcherAssert.assertThat((Object)execute.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
                    success.set(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        return success;
    }

    private void assertExpectedCallCount(int expectedCount, UrlPattern urlPattern) {
        int count = this.wireMockRule.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)urlPattern).build()).getCount();
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Object)expectedCount));
    }
}

