/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ResponseDribbleAcceptanceTest {
    private static final int SOCKET_TIMEOUT_MILLISECONDS = 500;
    private static final int DOUBLE_THE_SOCKET_TIMEOUT = 1000;
    private static final byte[] BODY_BYTES = "the long sentence being sent".getBytes();
    public static final double ERROR_MARGIN = 200.0;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(0, Integer.valueOf(0));
    private HttpClient httpClient;

    @Before
    public void init() throws IOException {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/warmup").willReturn(WireMock.ok()));
        this.httpClient = HttpClientFactory.createClient((int)500);
        this.httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://localhost:%d/warmup", this.wireMockRule.port())));
    }

    @Test
    public void requestIsSuccessfulButTakesLongerThanSocketTimeoutWhenDribbleIsEnabled() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delayedDribble").willReturn(WireMock.ok().withBody(BODY_BYTES).withChunkedDribbleDelay(BODY_BYTES.length, 1000)));
        long start = System.currentTimeMillis();
        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://localhost:%d/delayedDribble", this.wireMockRule.port())));
        byte[] responseBody = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.is((Object)BODY_BYTES));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(500)));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.closeTo((double)1000.0, (double)200.0));
    }

    @Test
    public void servesAStringBodyInChunks() throws Exception {
        int TOTAL_TIME = 300;
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delayedDribble").willReturn(WireMock.ok().withBody("Send this in many pieces please!!!").withChunkedDribbleDelay(2, 300)));
        long start = System.currentTimeMillis();
        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://localhost:%d/delayedDribble", this.wireMockRule.port())));
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        double duration = System.currentTimeMillis() - start;
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.is((Object)"Send this in many pieces please!!!"));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.closeTo((double)300.0, (double)50.0));
    }

    @Test
    public void requestIsSuccessfulAndBelowSocketTimeoutWhenDribbleIsDisabled() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/nonDelayedDribble").willReturn(WireMock.ok().withBody(BODY_BYTES)));
        long start = System.currentTimeMillis();
        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(String.format("http://localhost:%d/nonDelayedDribble", this.wireMockRule.port())));
        byte[] responseBody = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
        int duration = (int)(System.currentTimeMillis() - start);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)BODY_BYTES, (Matcher)Matchers.is((Object)responseBody));
        MatcherAssert.assertThat((Object)duration, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(500)));
    }
}

