/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SavingMappingsAcceptanceTest
extends AcceptanceTestBase {
    private static final File FILE_SOURCE_ROOT = new File("build/save-mappings-files");
    private static final File FILES_DIRECTORY = new File(FILE_SOURCE_ROOT, "__files");
    private static final File MAPPINGS_DIRECTORY = new File(FILE_SOURCE_ROOT, "mappings");
    static final TypeSafeDiagnosingMatcher<StubMapping> IS_PERSISTENT = new TypeSafeDiagnosingMatcher<StubMapping>(){

        public void describeTo(Description description) {
            description.appendText("a stub mapping marked as persistent");
        }

        protected boolean matchesSafely(StubMapping stub, Description mismatchDescription) {
            boolean result = stub.shouldBePersisted();
            if (!result) {
                mismatchDescription.appendText(stub.getId() + " not marked as persistent");
            }
            return result;
        }
    };

    private static void resetFileSourceRoot() {
        try {
            if (FILE_SOURCE_ROOT.exists()) {
                FileUtils.deleteDirectory((File)FILE_SOURCE_ROOT);
            }
            if (!FILES_DIRECTORY.mkdirs()) {
                throw new Exception("Could no create " + FILES_DIRECTORY.getAbsolutePath());
            }
            if (!MAPPINGS_DIRECTORY.mkdirs()) {
                throw new Exception("Could no create " + MAPPINGS_DIRECTORY.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @BeforeClass
    public static void setupServer() {
        SavingMappingsAcceptanceTest.resetFileSourceRoot();
        SavingMappingsAcceptanceTest.setupServer(WireMockConfiguration.wireMockConfig().fileSource((FileSource)new SingleRootFileSource(FILE_SOURCE_ROOT)));
    }

    @Before
    public void setUp() throws Exception {
        SavingMappingsAcceptanceTest.resetFileSourceRoot();
        WireMock.reset();
    }

    @Test
    public void savesMappingsToMappingsDirectory() {
        WireMockResponse response = testClient.get("/some/url", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/url")).willReturn(WireMock.aResponse().withBody("Response to /some/url")));
        WireMock.saveAllMappings();
        WireMock.resetToDefault();
        response = testClient.get("/some/url", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Response to /some/url"));
        MatcherAssert.assertThat((Object)WireMock.listAllStubMappings().getMappings(), (Matcher)Matchers.everyItem(IS_PERSISTENT));
    }

    @Test
    public void savedMappingIsDeletedFromTheDiskOnRemove() {
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delete/me").willReturn(WireMock.ok()));
        WireMock.saveAllMappings();
        MatcherAssert.assertThat((Object)MAPPINGS_DIRECTORY, SavingMappingsAcceptanceTest.containsFileWithNameContaining(stubMapping.getId().toString()));
        WireMock.removeStub((StubMapping)stubMapping);
        MatcherAssert.assertThat((Object)MAPPINGS_DIRECTORY, (Matcher)Matchers.not(SavingMappingsAcceptanceTest.containsFileWithNameContaining(stubMapping.getId().toString())));
    }

    private static Matcher<File> containsFileWithNameContaining(final String namePart) {
        return new TypeSafeDiagnosingMatcher<File>(){

            protected boolean matchesSafely(File directory, Description mismatchDescription) {
                boolean found = FluentIterable.from((Object[])directory.list()).filter((Predicate)new Predicate<String>(){

                    public boolean apply(String filename) {
                        return filename.contains(namePart);
                    }
                }).first().isPresent();
                if (!found) {
                    mismatchDescription.appendText("file with name containing " + namePart + " not found");
                }
                return found;
            }

            public void describeTo(Description description) {
                description.appendText("a file whose name contains " + namePart);
            }
        };
    }

    @Test
    public void doesNotDuplicateMappingsAlreadyPersistedToFileSystem() {
        WireMockResponse response = testClient.get("/some/url", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/url")).willReturn(WireMock.aResponse().withBody("Response to /some/url")));
        WireMock.saveAllMappings();
        WireMock.saveAllMappings();
        MatcherAssert.assertThat((Object)MAPPINGS_DIRECTORY.listFiles().length, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void doesNotDuplicateMappingsAlreadyPersistedAfterReset() {
        WireMockResponse response = testClient.get("/some/url", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/url")).willReturn(WireMock.aResponse().withBody("Response to /some/url")));
        WireMock.saveAllMappings();
        WireMock.resetToDefault();
        WireMock.saveAllMappings();
        MatcherAssert.assertThat((Object)MAPPINGS_DIRECTORY.listFiles().length, (Matcher)Matchers.is((Object)1));
    }
}

