/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class SnapshotDslAcceptanceTest
extends AcceptanceTestBase {
    private WireMockServer targetService;
    private WireMockServer proxyingService;
    private WireMockTestClient client;
    private WireMock adminClient;
    private StubMapping proxyStub;

    @Override
    public void init() {
        this.proxyingService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions(new Extension[]{new TestParameterisedTransformer()}).withRootDirectory(SnapshotDslAcceptanceTest.setupTempFileRoot().getAbsolutePath()));
        this.proxyingService.start();
        this.proxyingService.stubFor(WireMock.proxyAllTo((String)("http://localhost:" + wireMockServer.port())));
        this.targetService = wireMockServer;
        this.proxyStub = this.targetService.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
        this.client = new WireMockTestClient(this.proxyingService.port());
        WireMock.configureFor((int)this.proxyingService.port());
        this.adminClient = WireMock.create().port(this.proxyingService.port()).build();
    }

    @After
    public void proxyServerShutdown() {
        this.proxyingService.resetMappings();
        this.proxyingService.stop();
    }

    @Test
    public void snapshotRecordsAllLoggedRequestsWhenNoParametersPassed() throws Exception {
        this.targetService.stubFor(WireMock.get((String)"/one").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody("Number one")));
        this.client.get("/one", new TestHttpHeader[0]);
        this.client.get("/two", new TestHttpHeader[0]);
        this.client.postJson("/three", "{ \"counter\": 55 }", new TestHttpHeader[0]);
        List returnedMappings = this.proxyingService.snapshotRecord().getStubMappings();
        List serverMappings = this.proxyingService.getStubMappings();
        Assert.assertTrue((String)"All of the returned mappings should be present in the server", (boolean)serverMappings.containsAll(returnedMappings));
        Assert.assertThat((Object)returnedMappings.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/one"));
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getRequest().getHeaders(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.GET));
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getResponse().getHeaders().getHeader("Content-Type").firstValue(), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(0)).getResponse().getBody(), (Matcher)Matchers.is((Object)"Number one"));
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/two"));
        Assert.assertThat((Object)((StubMapping)returnedMappings.get(2)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/three"));
        ContentPattern bodyPattern = (ContentPattern)((StubMapping)returnedMappings.get(2)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)bodyPattern, (Matcher)Matchers.instanceOf(EqualToJsonPattern.class));
        JSONAssert.assertEquals((String)"{ \"counter\": 55 }", (String)bodyPattern.getExpected(), (boolean)true);
        EqualToJsonPattern equalToJsonPattern = (EqualToJsonPattern)bodyPattern;
        Assert.assertThat((Object)equalToJsonPattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)equalToJsonPattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void supportsFilteringByCriteria() throws Exception {
        this.client.get("/things/1", new TestHttpHeader[0]);
        this.client.get("/things/2", new TestHttpHeader[0]);
        this.client.get("/stuff/1", new TestHttpHeader[0]);
        this.client.get("/things/3", new TestHttpHeader[0]);
        this.client.get("/stuff/2", new TestHttpHeader[0]);
        List mappings = this.proxyingService.snapshotRecord(WireMock.recordSpec().onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/things/.*")))).getStubMappings();
        Assert.assertThat((Object)mappings.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)mappings, (Matcher)Matchers.everyItem(WireMatchers.stubMappingWithUrl((UrlPattern)WireMock.urlPathMatching((String)"/things.*"))));
        Assert.assertThat((Object)mappings, (Matcher)Matchers.not((Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl((UrlPattern)WireMock.urlPathMatching((String)"/stuff.*")))));
    }

    @Test
    public void supportsFilteringByServeEventId() throws Exception {
        this.client.get("/1", new TestHttpHeader[0]);
        this.client.get("/2", new TestHttpHeader[0]);
        this.client.get("/3", new TestHttpHeader[0]);
        UUID serveEventId = WireMatchers.findServeEventWithUrl(this.proxyingService.getAllServeEvents(), "/2").getId();
        List mappings = this.adminClient.takeSnapshotRecording(WireMock.recordSpec().onlyRequestIds(Collections.singletonList(serveEventId)));
        Assert.assertThat((Object)mappings.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((StubMapping)mappings.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/2"));
    }

    @Test
    public void willAllowNonProxiedEventsIfSpecified() throws Exception {
        this.proxyingService.removeStub(this.proxyStub);
        this.client.postJson("/record-this-anyway", "{ \"things\": 123 }", new TestHttpHeader[0]);
        List mappings = this.adminClient.takeSnapshotRecording(WireMock.recordSpec().allowNonProxied(true));
        Assert.assertThat((Object)mappings.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((StubMapping)mappings.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/record-this-anyway"));
        Assert.assertThat((Object)((ContentPattern)((StubMapping)mappings.get(0)).getRequest().getBodyPatterns().get(0)).getExpected(), WireMatchers.equalToJson("{ \"things\": 123 }"));
    }

    @Test
    public void supportsRequestHeaderCriteria() {
        this.client.get("/one", TestHttpHeader.withHeader("Yes", "1"), TestHttpHeader.withHeader("No", "1"));
        this.client.get("/two", TestHttpHeader.withHeader("Yes", "2"), TestHttpHeader.withHeader("Also-Yes", "BBB"));
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().captureHeader("Yes").captureHeader("Also-Yes", Boolean.valueOf(true)));
        StringValuePattern yesValuePattern = ((MultiValuePattern)((StubMapping)mappings.get(0)).getRequest().getHeaders().get("Yes")).getValuePattern();
        Assert.assertThat((Object)yesValuePattern, (Matcher)Matchers.instanceOf(EqualToPattern.class));
        Assert.assertThat((Object)((EqualToPattern)yesValuePattern).getCaseInsensitive(), (Matcher)Matchers.nullValue());
        Assert.assertFalse((boolean)((StubMapping)mappings.get(0)).getRequest().getHeaders().containsKey("No"));
        StringValuePattern alsoYesValuePattern = ((MultiValuePattern)((StubMapping)mappings.get(1)).getRequest().getHeaders().get("Also-Yes")).getValuePattern();
        Assert.assertThat((Object)alsoYesValuePattern, (Matcher)Matchers.instanceOf(EqualToPattern.class));
        Assert.assertThat((Object)((EqualToPattern)alsoYesValuePattern).getCaseInsensitive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void supportsBodyExtractCriteria() throws Exception {
        this.targetService.stubFor(WireMock.get((String)"/small/text").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody("123")));
        this.targetService.stubFor(WireMock.get((String)"/large/text").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"text/plain"}).withBody("12345678901234567")));
        this.targetService.stubFor(WireMock.get((String)"/small/binary").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/octet-stream"}).withBody(new byte[]{1, 2, 3})));
        this.targetService.stubFor(WireMock.get((String)"/large/binary").willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/octet-stream"}).withBody(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9})));
        this.client.get("/small/text", new TestHttpHeader[0]);
        this.client.get("/large/text", new TestHttpHeader[0]);
        this.client.get("/small/binary", new TestHttpHeader[0]);
        this.client.get("/large/binary", new TestHttpHeader[0]);
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().extractTextBodiesOver(10L).extractBinaryBodiesOver(5L));
        Assert.assertThat((Object)mappings.size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)WireMatchers.findMappingWithUrl(mappings, "/small/text").getResponse().getBodyFileName(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)WireMatchers.findMappingWithUrl(mappings, "/large/text").getResponse().getBodyFileName(), (Matcher)Matchers.containsString((String)"large_text"));
        Assert.assertThat((Object)WireMatchers.findMappingWithUrl(mappings, "/small/binary").getResponse().getBodyFileName(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)WireMatchers.findMappingWithUrl(mappings, "/large/binary").getResponse().getBodyFileName(), (Matcher)Matchers.containsString((String)"large_binary"));
    }

    @Test
    public void supportsDisablingRecordedStubPersistence() {
        this.client.get("/transient", new TestHttpHeader[0]);
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().makeStubsPersistent(false));
        Assert.assertThat((Object)WireMatchers.findMappingWithUrl(mappings, "/transient").isPersistent(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void buildsAScenarioForRepeatedIdenticalRequests() {
        this.targetService.stubFor(WireMock.get((String)"/stateful").willReturn(WireMock.ok((String)"One")));
        this.client.get("/stateful", new TestHttpHeader[0]);
        this.targetService.stubFor(WireMock.get((String)"/stateful").willReturn(WireMock.ok((String)"Two")));
        this.client.get("/stateful", new TestHttpHeader[0]);
        this.targetService.stubFor(WireMock.get((String)"/stateful").willReturn(WireMock.ok((String)"Three")));
        this.client.get("/stateful", new TestHttpHeader[0]);
        List mappings = WireMock.snapshotRecord();
        Assert.assertThat((Object)this.client.get("/stateful", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"One"));
        Assert.assertThat((Object)this.client.get("/stateful", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Two"));
        Assert.assertThat((Object)this.client.get("/stateful", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Three"));
        Assert.assertThat((Object)mappings, (Matcher)Matchers.everyItem(WireMatchers.isInAScenario()));
        Assert.assertThat((Object)((StubMapping)mappings.get(0)).getRequiredScenarioState(), (Matcher)Matchers.is((Object)"Started"));
        Assert.assertThat((Object)((StubMapping)mappings.get(1)).getRequiredScenarioState(), (Matcher)Matchers.is((Object)"scenario-1-stateful-2"));
        Assert.assertThat((Object)((StubMapping)mappings.get(2)).getRequiredScenarioState(), (Matcher)Matchers.is((Object)"scenario-1-stateful-3"));
    }

    @Test
    public void appliesTransformerWithParameters() {
        this.client.get("/transform-this", new TestHttpHeader[0]);
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().transformers(new String[]{"test-transformer"}).transformerParameters(Parameters.from((Map)ImmutableMap.of((Object)"headerKey", (Object)"X-Key", (Object)"headerValue", (Object)"My value"))));
        Assert.assertThat((Object)((StubMapping)mappings.get(0)).getResponse().getHeaders().getHeader("X-Key").firstValue(), (Matcher)Matchers.is((Object)"My value"));
    }

    @Test
    public void supportsConfigurationOfAutoRequestBodyPatternFactory() {
        this.client.postJson("/some-json", "{}", new TestHttpHeader[0]);
        this.client.postWithBody("/some-json", "<foo/>", "application/xml", "utf-8");
        this.client.postWithBody("/some-json", "foo", "application/text", "utf-8");
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().chooseBodyMatchTypeAutomatically(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)));
        EqualToJsonPattern jsonBodyPattern = (EqualToJsonPattern)((StubMapping)mappings.get(0)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)jsonBodyPattern.getEqualToJson(), (Matcher)Matchers.is((Object)"{}"));
        Assert.assertThat((Object)jsonBodyPattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)jsonBodyPattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)false));
        EqualToXmlPattern xmlBodyPattern = (EqualToXmlPattern)((StubMapping)mappings.get(1)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)xmlBodyPattern.getEqualToXml(), (Matcher)Matchers.is((Object)"<foo/>"));
        EqualToPattern textBodyPattern = (EqualToPattern)((StubMapping)mappings.get(2)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)textBodyPattern.getEqualTo(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)textBodyPattern.getCaseInsensitive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void supportsConfigurationOfRequestBodyPatternFactoryWithEqualToJsonPattern() {
        this.client.postJson("/some-json", "{}", new TestHttpHeader[0]);
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().matchRequestBodyWithEqualToJson(Boolean.valueOf(false), Boolean.valueOf(true)));
        EqualToJsonPattern bodyPattern = (EqualToJsonPattern)((StubMapping)mappings.get(0)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)bodyPattern.isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)bodyPattern.isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void supportsConfigurationOfRequestBodyPatternFactoryWithEqualToXmlPattern() {
        this.client.postWithBody("/some-json", "<foo/>", "application/xml", "utf-8");
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().matchRequestBodyWithEqualToXml());
        Assert.assertThat(((StubMapping)mappings.get(0)).getRequest().getBodyPatterns().get(0), (Matcher)Matchers.instanceOf(EqualToXmlPattern.class));
    }

    @Test
    public void supportsConfigurationOfRequestBodyPatternFactoryWithEqualToPattern() {
        this.client.postWithBody("/some-json", "foo", "application/text", "utf-8");
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().matchRequestBodyWithEqualTo(Boolean.valueOf(true)));
        EqualToPattern bodyPattern = (EqualToPattern)((StubMapping)mappings.get(0)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)bodyPattern.getCaseInsensitive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void defaultsToAutomaticRequestBodyPattern() {
        this.client.postJson("/some-json", "{}", new TestHttpHeader[0]);
        List mappings = WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec());
        EqualToJsonPattern bodyPattern = (EqualToJsonPattern)((StubMapping)mappings.get(0)).getRequest().getBodyPatterns().get(0);
        Assert.assertThat((Object)bodyPattern, (Matcher)Matchers.is((Object)new EqualToJsonPattern("{}", Boolean.valueOf(true), Boolean.valueOf(true))));
    }

    @Test
    public void staticClientIsSupportedWithDefaultSpec() {
        this.client.get("/get-this", new TestHttpHeader[0]);
        WireMock.snapshotRecord();
        List serverMappings = this.proxyingService.getStubMappings();
        Assert.assertThat((Object)serverMappings, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/get-this")));
    }

    @Test
    public void staticClientIsSupportedWithSpecProvided() {
        this.client.get("/get-this", new TestHttpHeader[0]);
        this.client.get("/but-not-this", new TestHttpHeader[0]);
        WireMock.snapshotRecord((RecordSpecBuilder)WireMock.recordSpec().onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/get-this"))));
        List serverMappings = this.proxyingService.getStubMappings();
        Assert.assertThat((Object)serverMappings, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/get-this")));
        Assert.assertThat((Object)serverMappings, (Matcher)Matchers.not((Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/but-not-this"))));
    }

    @Test
    public void instanceClientIsSupportedWithDefaultSpec() {
        this.client.get("/get-this-too", new TestHttpHeader[0]);
        this.adminClient.takeSnapshotRecording();
        List serverMappings = this.proxyingService.getStubMappings();
        Assert.assertThat((Object)serverMappings, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/get-this-too")));
    }

    @Test
    public void instanceClientIsSupportedWithSpecProvided() {
        this.client.get("/get-this", new TestHttpHeader[0]);
        this.client.get("/but-not-this", new TestHttpHeader[0]);
        this.adminClient.takeSnapshotRecording(WireMock.recordSpec().onlyRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/get-this"))));
        List serverMappings = this.proxyingService.getStubMappings();
        Assert.assertThat((Object)serverMappings, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/get-this")));
        Assert.assertThat((Object)serverMappings, (Matcher)Matchers.not((Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/but-not-this"))));
    }

    public static class TestParameterisedTransformer
    extends StubMappingTransformer {
        public StubMapping transform(StubMapping stubMapping, FileSource files, Parameters parameters) {
            ResponseDefinition newResponse = ResponseDefinitionBuilder.like((ResponseDefinition)stubMapping.getResponse()).but().withHeader(parameters.getString("headerKey"), new String[]{parameters.getString("headerValue")}).build();
            stubMapping.setResponse(newResponse);
            return stubMapping;
        }

        public boolean applyGlobally() {
            return false;
        }

        public String getName() {
            return "test-transformer";
        }
    }
}

