/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubImportBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;

public class StubImportAcceptanceTest
extends AcceptanceTestBase {
    private static Admin admin;

    @BeforeClass
    public static void setup() {
        admin = wireMockServer;
    }

    @Test
    public void importsAllStubsWhenNoneAreAlreadyPresent() {
        admin.importStubs(StubImport.stubImport().stub(WireMock.get((String)"/one").willReturn(WireMock.ok())).stub(WireMock.post((String)"/two").willReturn(WireMock.ok())).stub(WireMock.put((String)"/three").willReturn(WireMock.ok())).build());
        List stubs = admin.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/one")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/two")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/three")));
    }

    @Test
    public void overwritesExistingStubsByDefault() {
        UUID id1 = UUID.randomUUID();
        wm.stubFor(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Original")));
        admin.importStubs(StubImport.stubImport().stub(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Updated"))).stub(WireMock.post((String)"/two").willReturn(WireMock.ok())).stub(WireMock.put((String)"/three").willReturn(WireMock.ok())).build());
        List stubs = admin.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((StubMapping)stubs.get(2)).getResponse().getBody(), (Matcher)Matchers.is((Object)"Updated"));
    }

    @Test
    public void ignoresExistingStubsIfConfigured() {
        UUID id1 = UUID.randomUUID();
        wm.stubFor(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Original")));
        WireMock wireMock = new WireMock(wireMockServer.port());
        wireMock.importStubMappings(StubImport.stubImport().stub(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Updated"))).stub(WireMock.post((String)"/two").willReturn(WireMock.ok())).stub(WireMock.put((String)"/three").willReturn(WireMock.ok())).ignoreExisting());
        List stubs = admin.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((StubMapping)stubs.get(2)).getResponse().getBody(), (Matcher)Matchers.is((Object)"Original"));
    }

    @Test
    public void deletesStubsNotInImportIfConfigured() {
        UUID id1 = UUID.randomUUID();
        wm.stubFor(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Original")));
        wm.stubFor(WireMock.get((String)"/four").willReturn(WireMock.ok()));
        wm.stubFor(WireMock.get((String)"/five").willReturn(WireMock.ok()));
        WireMock.importStubs((StubImportBuilder)StubImport.stubImport().stub(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Updated"))).stub(WireMock.post((String)"/two").willReturn(WireMock.ok())).stub(WireMock.put((String)"/three").willReturn(WireMock.ok())).deleteAllExistingStubsNotInImport());
        List stubs = admin.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/one")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/two")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/three")));
        MatcherAssert.assertThat((Object)((StubMapping)stubs.get(2)).getResponse().getBody(), (Matcher)Matchers.is((Object)"Updated"));
    }

    @Test
    public void doesNotDeleteStubsNotInImportIfNotConfigured() {
        UUID id1 = UUID.randomUUID();
        wm.stubFor(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Original")));
        wm.stubFor(WireMock.get((String)"/four").willReturn(WireMock.ok()));
        wm.stubFor(WireMock.get((String)"/five").willReturn(WireMock.ok()));
        WireMock.importStubs((StubImportBuilder)StubImport.stubImport().stub(WireMock.get((String)"/one").withId(id1).willReturn(WireMock.ok((String)"Updated"))).stub(WireMock.post((String)"/two").willReturn(WireMock.ok())).stub(WireMock.put((String)"/three").willReturn(WireMock.ok())).overwriteExisting().doNotDeleteExistingStubs());
        List stubs = admin.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs.size(), (Matcher)Matchers.is((Object)5));
    }
}

