/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.NotPermittedException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StubLifecycleListenerAcceptanceTest {
    TestStubLifecycleListener loggingListener = new TestStubLifecycleListener();
    ExceptionThrowingStubLifecycleListener exceptionThrowingListener = new ExceptionThrowingStubLifecycleListener();
    @ClassRule
    public static TemporaryFolder tempDir = new TemporaryFolder();
    @Rule
    public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory(tempDir.getRoot().getAbsolutePath()).extensions(new Extension[]{this.loggingListener, this.exceptionThrowingListener}));

    @Before
    public void init() {
        this.loggingListener.events.clear();
        this.exceptionThrowingListener.throwException = false;
    }

    @Test
    public void beforeAndAfterMethodsAreCalledForStubCreation() {
        this.wm.stubFor(WireMock.get((String)"/test").withName("Created").willReturn(WireMock.ok()));
        Assert.assertThat((Object)this.loggingListener.events.get(0), (Matcher)Matchers.is((Object)"beforeStubCreated, name: Created"));
        Assert.assertThat((Object)this.loggingListener.events.get(1), (Matcher)Matchers.is((Object)"afterStubCreated, name: Created"));
    }

    @Test
    public void beforeAndAfterMethodsAreCalledForStubEdit() {
        UUID id = UUID.randomUUID();
        this.wm.stubFor(WireMock.get((String)"/test").withId(id).withName("Created").willReturn(WireMock.ok()));
        this.wm.editStub(WireMock.get((String)"/test").withId(id).withName("Edited").willReturn(WireMock.ok()));
        Assert.assertThat((Object)this.loggingListener.events.get(2), (Matcher)Matchers.is((Object)"beforeStubEdited, old name: Created, new name: Edited"));
        Assert.assertThat((Object)this.loggingListener.events.get(3), (Matcher)Matchers.is((Object)"afterStubEdited, old name: Created, new name: Edited"));
    }

    @Test
    public void beforeAndAfterMethodsAreCalledForStubRemove() {
        StubMapping stub = this.wm.stubFor(WireMock.get((String)"/test").withName("To remove").willReturn(WireMock.ok()));
        this.wm.removeStub(stub);
        Assert.assertThat((Object)this.loggingListener.events.get(2), (Matcher)Matchers.is((Object)"beforeStubRemoved, name: To remove"));
        Assert.assertThat((Object)this.loggingListener.events.get(3), (Matcher)Matchers.is((Object)"afterStubRemoved, name: To remove"));
    }

    @Test
    public void beforeAndAfterMethodsAreCalledForStubsReset() {
        this.wm.stubFor(WireMock.get((String)"/test").withName("To remove").willReturn(WireMock.ok()));
        this.wm.resetMappings();
        Assert.assertThat((Object)this.loggingListener.events.get(2), (Matcher)Matchers.is((Object)"beforeStubsReset"));
        Assert.assertThat((Object)this.loggingListener.events.get(3), (Matcher)Matchers.is((Object)"afterStubsReset"));
    }

    @Test
    public void stubCreationCanBeVetoedWhenExceptionIsThrown() {
        this.exceptionThrowingListener.throwException = true;
        Assert.assertTrue((boolean)this.wm.listAllStubMappings().getMappings().isEmpty());
        try {
            this.wm.stubFor(WireMock.get((String)"/test").withName("Created").willReturn(WireMock.ok()));
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotPermittedException.class));
        }
        Assert.assertTrue((boolean)this.wm.listAllStubMappings().getMappings().isEmpty());
    }

    @Test
    public void sensibleExceptionIsThrownWhenRemoteAndExceptionThrownFromListener() {
        WireMock wmRemote = new WireMock(this.wm.port());
        this.exceptionThrowingListener.throwException = true;
        try {
            wmRemote.register(WireMock.get((String)"/test").withName("Created").willReturn(WireMock.ok()));
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NotPermittedException.class));
            Assert.assertThat((Object)((NotPermittedException)e).getErrors().first().getTitle(), (Matcher)Matchers.is((Object)"quota exhausted"));
        }
    }

    public static class ExceptionThrowingStubLifecycleListener
    implements StubLifecycleListener {
        public boolean throwException = false;

        public void beforeStubCreated(StubMapping stub) {
            this.throwIfRequired();
        }

        public void afterStubCreated(StubMapping stub) {
        }

        public void beforeStubEdited(StubMapping oldStub, StubMapping newStub) {
            this.throwIfRequired();
        }

        public void afterStubEdited(StubMapping oldStub, StubMapping newStub) {
        }

        public void beforeStubRemoved(StubMapping stub) {
            this.throwIfRequired();
        }

        public void afterStubRemoved(StubMapping stub) {
        }

        public void beforeStubsReset() {
            this.throwIfRequired();
        }

        public void afterStubsReset() {
        }

        public String getName() {
            return "exception-thrower";
        }

        private void throwIfRequired() {
            if (this.throwException) {
                throw new NotPermittedException(Errors.notPermitted((String)"quota exhausted"));
            }
        }
    }

    public static class TestStubLifecycleListener
    implements StubLifecycleListener {
        public List<String> events = new ArrayList<String>();

        public void beforeStubCreated(StubMapping stub) {
            this.events.add("beforeStubCreated, name: " + stub.getName());
        }

        public void afterStubCreated(StubMapping stub) {
            this.events.add("afterStubCreated, name: " + stub.getName());
        }

        public void beforeStubEdited(StubMapping oldStub, StubMapping newStub) {
            this.events.add("beforeStubEdited, old name: " + oldStub.getName() + ", new name: " + newStub.getName());
        }

        public void afterStubEdited(StubMapping oldStub, StubMapping newStub) {
            this.events.add("afterStubEdited, old name: " + oldStub.getName() + ", new name: " + newStub.getName());
        }

        public void beforeStubRemoved(StubMapping stub) {
            this.events.add("beforeStubRemoved, name: " + stub.getName());
        }

        public void afterStubRemoved(StubMapping stub) {
            this.events.add("afterStubRemoved, name: " + stub.getName());
        }

        public void beforeStubsReset() {
            this.events.add("beforeStubsReset");
        }

        public void afterStubsReset() {
            this.events.add("afterStubsReset");
        }

        public String getName() {
            return "test-stub-lifecycle-listener";
        }
    }
}

