/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class StubMetadataAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void createAndRetrieveStubMetadata() {
        UUID id = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/with-metadata").withId(id).withMetadata(Metadata.metadata().attr("one", (Object)1).attr("two", (Object)"2").attr("three", (Object)true).attr("four", Metadata.metadata().attr("five", (Object)"55555")).list("six", new Object[]{1, 2, 3})));
        StubMapping retrievedStub = WireMock.getSingleStubMapping((UUID)id);
        Metadata metadata = retrievedStub.getMetadata();
        MatcherAssert.assertThat((Object)metadata.getInt("one"), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)metadata.getString("two"), (Matcher)Matchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)metadata.getBoolean("three"), (Matcher)Matchers.is((Object)true));
        Metadata four = metadata.getMetadata("four");
        MatcherAssert.assertThat((Object)four.getString("five"), (Matcher)Matchers.is((Object)"55555"));
        List six = metadata.getList("six");
        MatcherAssert.assertThat((Object)((Integer)six.get(0)), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void canFindStubsByMetadata() {
        UUID id = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/with-metadata").withId(id).withMetadata(Metadata.metadata().attr("four", Metadata.metadata().attr("five", (Object)"55555")).list("six", new Object[]{1, 2, 3})));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/without-metadata"));
        List stubs = WireMock.findStubsByMetadata((StringValuePattern)WireMock.matchingJsonPath((String)"$..four.five", (StringValuePattern)WireMock.containing((String)"55555")));
        StubMapping retrievedStub = (StubMapping)stubs.get(0);
        MatcherAssert.assertThat((Object)retrievedStub.getId(), (Matcher)Matchers.is((Object)id));
    }

    @Test
    public void canRemoveStubsByMetadata() {
        UUID id = UUID.randomUUID();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/with-metadata").withId(id).withMetadata(Metadata.metadata().attr("four", Metadata.metadata().attr("five", (Object)"55555")).list("six", new Object[]{1, 2, 3})));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/without-metadata"));
        WireMock.removeStubsByMetadata((StringValuePattern)WireMock.matchingJsonPath((String)"$..four.five", (StringValuePattern)WireMock.containing((String)"55555")));
        MatcherAssert.assertThat((Object)WireMock.listAllStubMappings().getMappings(), (Matcher)Matchers.not((Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/with-metadata"))));
    }
}

