/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class StubbingWithBrowserProxyAcceptanceTest {
    static final String EXPECTED_RESPONSE_BODY = "Got it";
    @ClassRule
    public static WireMockClassRule wm = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true).notifier((Notifier)new ConsoleNotifier(true)));
    @Rule
    public WireMockClassRule instance = wm;
    static CloseableHttpClient client;

    @BeforeClass
    public static void init() {
        client = HttpClientBuilder.create().setDnsResolver((DnsResolver)new CustomLocalTldDnsResolver("internal")).setProxy(new HttpHost("localhost", wm.port())).build();
    }

    @Test
    public void matchesOnHostname() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withHost(WireMock.equalTo((String)"righthost.internal")).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://righthost.internal/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void doesNotMatchOnHostnameWhenIncorrect() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withHost(WireMock.equalTo((String)"righthost.internal")).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://wronghost.internal/mypath").build();
        this.makeRequestAndAssertNotOk(request);
    }

    @Test
    public void matchesAnyHostnameWhenNotSpecified() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://whatever.internal/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void matchesPortNumber() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withPort(1234).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://localhost:1234/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void doesNotMatchOnPortNumberWhenIncorrect() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withPort(1234).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://localhost:4321/mypath").build();
        this.makeRequestAndAssertNotOk(request);
    }

    @Test
    public void matchesOnScheme() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withScheme("http").willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://whatever/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void doesNotMatchWhenSchemeIncorrect() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withScheme("https").willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        HttpUriRequest request = RequestBuilder.get((String)"http://whatever/mypath").build();
        this.makeRequestAndAssertNotOk(request);
    }

    private void makeRequestAndAssertOk(HttpUriRequest request) throws Exception {
        try (CloseableHttpResponse response = client.execute(request);){
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.is((Object)EXPECTED_RESPONSE_BODY));
        }
    }

    private void makeRequestAndAssertNotOk(HttpUriRequest request) throws Exception {
        try (CloseableHttpResponse response = client.execute(request);){
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.not((Matcher)Matchers.is((Object)EXPECTED_RESPONSE_BODY)));
        }
    }

    private static class CustomLocalTldDnsResolver
    implements DnsResolver {
        private final String tldToSendToLocalhost;

        public CustomLocalTldDnsResolver(String tldToSendToLocalhost) {
            this.tldToSendToLocalhost = tldToSendToLocalhost;
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            if (host.endsWith("." + this.tldToSendToLocalhost)) {
                return new InetAddress[]{InetAddress.getLocalHost()};
            }
            return new SystemDefaultDnsResolver().resolve(host);
        }
    }
}

