/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class TransferEncodingAcceptanceTest {
    WireMockServer wm;
    WireMockTestClient testClient;

    @Test
    public void sendsContentLengthWhenTransferEncodingChunkedPolicyIsNever() {
        this.startWithChunkedEncodingPolicy(Options.ChunkedEncodingPolicy.NEVER);
        String url = "/content-length-encoding";
        String body = "Body content";
        this.wm.stubFor(WireMock.get((String)"/content-length-encoding").willReturn(WireMock.ok((String)"Body content")));
        WireMockResponse response = this.testClient.get("/content-length-encoding", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        String expectedContentLength = String.valueOf("Body content".getBytes().length);
        MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.is((Object)expectedContentLength));
    }

    @Test
    public void sendsTransferEncodingChunkedWhenPolicyIsAlways() {
        this.startWithChunkedEncodingPolicy(Options.ChunkedEncodingPolicy.ALWAYS);
        String url = "/chunked-encoding-always";
        String body = "Body content";
        this.wm.stubFor(WireMock.get((String)"/chunked-encoding-always").willReturn(WireMock.ok((String)"Body content")));
        WireMockResponse response = this.testClient.get("/chunked-encoding-always", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void sendsTransferEncodingChunkedWhenPolicyIsBodyFileAndBodyFileIsUsed() {
        this.startWithChunkedEncodingPolicy(Options.ChunkedEncodingPolicy.BODY_FILE);
        String fileUrl = "/chunked-encoding-body";
        String inlineBodyUrl = "/chunked-encoding-body-file";
        this.wm.stubFor(WireMock.get((String)"/chunked-encoding-body").willReturn(WireMock.ok().withBodyFile("plain-example.txt")));
        this.wm.stubFor(WireMock.get((String)"/chunked-encoding-body-file").willReturn(WireMock.ok((String)"Body content")));
        WireMockResponse response = this.testClient.get("/chunked-encoding-body", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.nullValue());
        response = this.testClient.get("/chunked-encoding-body-file", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void sendsContentLengthWhenTransferEncodingChunkedPolicyIsNeverAndDribbleDelayIsApplied() {
        this.startWithChunkedEncodingPolicy(Options.ChunkedEncodingPolicy.NEVER);
        String url = "/content-length-encoding";
        String body = "Slightly longer body content in this string";
        this.wm.stubFor(WireMock.get((String)"/content-length-encoding").willReturn(WireMock.ok((String)"Slightly longer body content in this string").withChunkedDribbleDelay(5, 200)));
        WireMockResponse response = this.testClient.get("/content-length-encoding", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        String expectedContentLength = String.valueOf("Slightly longer body content in this string".getBytes().length);
        MatcherAssert.assertThat((Object)response.firstHeader("Transfer-Encoding"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Length"), (Matcher)Matchers.is((Object)expectedContentLength));
    }

    private void startWithChunkedEncodingPolicy(Options.ChunkedEncodingPolicy chunkedEncodingPolicy) {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().withRootDirectory(TestFiles.filePath("test-file-root")).useChunkedTransferEncoding(chunkedEncodingPolicy));
        this.wm.start();
        this.testClient = new WireMockTestClient(this.wm.port());
    }

    @After
    public void cleanup() {
        this.wm.stop();
    }
}

