/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class VerificationAcceptanceTest {

    public static class JournalMaxEntriesRestricted {
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().maxRequestJournalEntries(Optional.of((Object)2)), false);

        @Test
        public void maxLengthIs2() {
            WireMockTestClient testClient = new WireMockTestClient(this.wireMockRule.port());
            testClient.get("/request1", new TestHttpHeader[0]);
            testClient.get("/request2", new TestHttpHeader[0]);
            testClient.get("/request3", new TestHttpHeader[0]);
            WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request1")));
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request2")));
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request3")));
        }
    }

    public static class JournalDisabled {
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().disableRequestJournal(), false);

        @Test(expected=RequestJournalDisabledException.class)
        public void verifyThrowsExceptionWhenVerificationAttemptedAndRequestJournalDisabled() {
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/whatever")));
        }

        @Test(expected=RequestJournalDisabledException.class)
        public void findAllThrowsExceptionWhenVerificationAttemptedAndRequestJournalDisabled() {
            WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/whatever")));
        }
    }

    public static class JournalEnabled
    extends AcceptanceTestBase {
        private static final String SAMPLE_JSON = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"thing\": {\t\t\t\t\t\t\t\t\t\n\t\t\"importantKey\": \"Important value\"\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t";

        @Test
        public void verifiesRequestBasedOnUrlOnly() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested?query")));
        }

        @Test
        public void anyRequestedForMatchesAnyHttpMethod() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.anyRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested?query")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlEqualsWhenQueryMissing() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlEqualsWhenPathShorter() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requeste?query")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlEqualsWhenExtraPathPresent() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested/?query")));
        }

        @Test
        public void verifiesRequestBasedOnUrlPathOnly() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/this/got/requested")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlPathEqualsWhenPathShorter() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/this/got/requeste")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlPathEqualsWhenExtraPathPresent() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/this/got/requested/")));
        }

        @Test
        public void verifiesRequestBasedOnUrlPathPatternOnly() {
            testClient.get("/this/got/requested", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/(.*?)/got/.*")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlPathPatternWhenOnlyPrefixMatching() {
            testClient.get("/this/got/requested", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/(.*?)/got/")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionOnUrlPathPatternWhenOnlySuffixMatching() {
            testClient.get("/this/got/requested", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/got/.*")));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionWhenNoMatch() {
            testClient.get("/this/got/requested", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/did/not")));
        }

        @Test
        public void verifiesWithHeaders() {
            testClient.put("/update/this", TestHttpHeader.withHeader("Content-Type", "application/json"), TestHttpHeader.withHeader("Encoding", "UTF-8"));
            WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlMatching((String)"/[a-z]+/this")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Encoding", WireMock.notMatching((String)"LATIN-1")));
        }

        @Test
        public void verifiesWithMultiValueHeaders() {
            testClient.get("/multi/value/header", TestHttpHeader.withHeader("X-Thing", "One"), TestHttpHeader.withHeader("X-Thing", "Two"), TestHttpHeader.withHeader("X-Thing", "Three"));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi/value/header")).withHeader("X-Thing", WireMock.equalTo((String)"Two")).withHeader("X-Thing", WireMock.matching((String)"Thr.*")));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi/value/header")).withHeader("X-Thing", WireMock.equalTo((String)"Three")));
        }

        @Test
        public void findsRequestsWithMultiValueHeaders() {
            testClient.get("/multi/value/header", TestHttpHeader.withHeader("X-Thing", "One"), TestHttpHeader.withHeader("X-Thing", "Two"), TestHttpHeader.withHeader("X-Thing", "Three"));
            List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi/value/header")));
            HttpHeaders headers = ((LoggedRequest)requests.get(0)).getHeaders();
            MatcherAssert.assertThat((Object)headers.getHeader("X-Thing").values().size(), (Matcher)Matchers.is((Object)3));
            MatcherAssert.assertThat(headers.getHeader("X-Thing").values().get(1), (Matcher)Matchers.is((Object)"Two"));
        }

        @Test(expected=VerificationException.class)
        public void throwsVerificationExceptionWhenHeadersDoNotMatch() {
            testClient.put("/to/modify", TestHttpHeader.withHeader("Content-Type", "application/json"), TestHttpHeader.withHeader("Encoding", "LATIN-1"));
            WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/to/modify")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Encoding", WireMock.notMatching((String)"LATIN-1")));
        }

        @Test
        public void verifiesWithBody() {
            testClient.postWithBody("/add/this", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/this")).withRequestBody((ContentPattern)WireMock.matching((String)".*\"importantKey\": \"Important value\".*")));
        }

        @Test
        public void verifiesWithBodyContainingJson() {
            testClient.postWithBody("/body/contains", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/contains")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.thing")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$..thing[?(@.importantKey == 'Important value')]")));
        }

        @Test
        public void verifiesWithBodyEquallingJson() {
            testClient.postWithBody("/body/json", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/json")).withRequestBody((ContentPattern)WireMock.equalToJson((String)SAMPLE_JSON)));
        }

        @Test
        public void verifiesWithBodyEquallingJsonWithCompareMode() {
            testClient.postWithBody("/body/json/lenient", "{ \"message\": \"Hello\", \"key\": \"welcome.message\" }", "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/json/lenient")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{ \"message\": \"Hello\" }", (boolean)true, (boolean)true)));
        }

        @Test
        public void verifiesWithBodyEquallingXml() {
            testClient.postWithBody("/body/xml", "<thing><subThing>The stuff</subThing></thing>", "application/xml", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/xml")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<thing>     <subThing>The stuff\n</subThing>\n\n    </thing>")));
        }

        @Test
        public void verifiesWithBodyEquallingXpath() {
            testClient.postWithBody("/body/xml", "<thing><subThing>The stuff</subThing></thing>", "application/xml", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/xml")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//subThing[.='The stuff']")));
        }

        @Test
        public void verifiesWithBodyEquallingNamespacedXpath() {
            testClient.postWithBody("/namespaced/xml", "<t:thing xmlns:t='http://things' xmlns:s='http://subthings'><s:subThing>The stuff</s:subThing></t:thing>", "application/xml", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/namespaced/xml")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//s:subThing[.='The stuff']").withXPathNamespace("t", "http://things").withXPathNamespace("s", "http://subthings")));
        }

        @Test
        public void verifiesWithBodyContainingString() {
            testClient.postWithBody("/body/json", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/json")).withRequestBody((ContentPattern)WireMock.containing((String)"Important value")));
        }

        @Test
        public void verifiesWithQueryParam() {
            testClient.get("/query?param=my-value", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param", WireMock.equalTo((String)"my-value")));
        }

        @Test
        public void queryParameterMatchingCopesWithSpaces() {
            testClient.get("/spacey-query?param=My%20Value", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/spacey-query")).withQueryParam("param", WireMock.equalTo((String)"My Value")));
        }

        @Test(expected=VerificationException.class)
        public void verifyIsFalseWithQueryParamNotMatched() {
            testClient.get("/query?param=my-value", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param", WireMock.equalTo((String)"wrong-value")));
        }

        @Test(expected=VerificationException.class)
        public void verifyIsFalseWhenExpectedQueryParamMissing() {
            testClient.get("/query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param", WireMock.equalTo((String)"my-value")));
        }

        @Test(expected=VerificationException.class)
        public void resetErasesCounters() {
            testClient.get("/count/this", new TestHttpHeader[0]);
            testClient.get("/count/this", new TestHttpHeader[0]);
            testClient.get("/count/this", new TestHttpHeader[0]);
            WireMock.reset();
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/count/this")));
        }

        @Test
        public void verifiesArbitraryRequestCount() {
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            WireMock.verify((int)4, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        private void getCountableRequests(int count) {
            for (int i = 0; i < count; ++i) {
                testClient.get("/add/to/count", new TestHttpHeader[0]);
            }
        }

        @Test
        public void verifiesLessThanCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyLessThanCountWithEqualRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyLessThanCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesLessThanOrExactlyCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesLessThanOrExactlyCountWithEqualRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyLessThanOrExactlyCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyExactCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesExactlyThanCountWithExactRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyExactCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyMoreThanOrExactlyCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesMoreThanOrExactlyCountWithEqualRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesMoreThanOrExactlyCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyMoreThanCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test(expected=VerificationException.class)
        public void doesNotVerifyMoreThanCountWithEqualRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesMoreThanCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesHeaderAbsent() {
            testClient.get("/without/header", TestHttpHeader.withHeader("Content-Type", "application/json"));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/without/header")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withoutHeader("Accept"));
        }

        @Test(expected=VerificationException.class)
        public void failsVerificationWhenAbsentHeaderPresent() {
            testClient.get("/without/another/header", TestHttpHeader.withHeader("Content-Type", "application/json"));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/without/another/header")).withoutHeader("Content-Type"));
        }

        @Test
        public void verifiesBodyAbsent() throws Exception {
            testClient.post("/no/body", (HttpEntity)new StringEntity(""), new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/no/body")).withRequestBody((ContentPattern)WireMock.absent()));
        }

        @Test(expected=VerificationException.class)
        public void failsVerificationWhenAbsentBodyPresent() throws Exception {
            testClient.post("/no/body", (HttpEntity)new StringEntity("not absent"), new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/no/body")).withRequestBody((ContentPattern)WireMock.absent()));
        }

        @Test
        public void showsDiffWithNearestMissWhenNoRequestsMatchedAndNearMissesAreAvailable() {
            testClient.get("/my-near-miss", new TestHttpHeader[0]);
            testClient.get("/near-miss", new TestHttpHeader[0]);
            try {
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/a-near-miss")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/a-near-miss\n", (Object)"GET\n/my-near-miss\n")));
            }
        }

        @Test
        public void showsExpectedRequestAndCountShortfallWhenNotEnoughMatchingRequestsAreReceived() {
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            try {
                WireMock.verify((int)3, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("Expected exactly 3 requests matching the following pattern but received 2:\n{" + System.lineSeparator() + "  \"url\" : \"/hit\"," + System.lineSeparator() + "  \"method\" : \"GET\"" + System.lineSeparator() + "}")));
            }
        }

        @Test
        public void showsNearMissDiffWhenCountSpecifiedAndNoMatchingRequestsAreReceived() {
            testClient.get("/miss", new TestHttpHeader[0]);
            testClient.get("/miss", new TestHttpHeader[0]);
            try {
                WireMock.verify((int)3, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/miss\n")));
            }
        }

        @Test
        public void showsExpectedRequestAndCountShortfallWhenWrongNumberOfMatchingRequestsAreReceived() {
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)2), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("Expected less than 2 requests matching the following pattern but received 4:\n{" + System.lineSeparator() + "  \"url\" : \"/hit\"," + System.lineSeparator() + "  \"method\" : \"GET\"" + System.lineSeparator() + "}")));
            }
        }

        @Test
        public void showsNearMissDiffWhenCountMatchSpecifiedAndNoMatchingRequestsAreReceived() {
            testClient.get("/miss", new TestHttpHeader[0]);
            testClient.get("/miss", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)4), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/miss\n")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForLessThan() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)2), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected less than 2 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForLessThanOrExactly() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)2), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected less than or exactly 2 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForExactly() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)12), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected exactly 12 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForMoreThan() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)12), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected more than 12 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void verifiesPatchRequests() {
            testClient.patchWithBody("/patch/this", SAMPLE_JSON, "application/json", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.patchRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/patch/this")).withRequestBody((ContentPattern)WireMock.matching((String)".*\"importantKey\": \"Important value\".*")));
        }

        @Test
        public void verifiesRequestsWithCountMatchingStrategy() {
            testClient.get("/custom-match-this", new TestHttpHeader[0]);
            testClient.get("/custom-match-this", new TestHttpHeader[0]);
            wireMockServer.verify(WireMock.exactly((int)2), WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/custom-match-this")));
        }

        @Test
        public void verifiesRequestsViaCustomMatcher() {
            testClient.get("/custom-match-this", new TestHttpHeader[0]);
            testClient.get("/custom-match-that", new TestHttpHeader[0]);
            wireMockServer.verify(2, WireMock.requestMadeFor((ValueMatcher)new RequestMatcher(){

                public MatchResult match(Request request) {
                    return MatchResult.of((boolean)request.getUrl().contains("custom-match"));
                }

                public String getName() {
                    return "inline";
                }
            }));
        }

        @Test
        public void verifiesRequestsViaCustomMatcherRemotely() {
            testClient.get("/remote-custom-match-this", new TestHttpHeader[0]);
            testClient.get("/remote-custom-match-that", new TestHttpHeader[0]);
            WireMock.verify((int)2, (RequestPatternBuilder)WireMock.requestMadeFor((ValueMatcher)new ValueMatcher<Request>(){

                public MatchResult match(Request value) {
                    return MatchResult.of((boolean)value.getUrl().contains("remote-custom-match"));
                }
            }));
        }

        @Test
        public void copesWithAttemptedXmlBodyMatchWhenRequestHasNoXmlBody() {
            testClient.post("/missing-xml", (HttpEntity)new StringEntity("", ContentType.TEXT_PLAIN), new TestHttpHeader[0]);
            try {
                WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/missing-xml")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<my-stuff />")));
                Assert.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"No requests exactly matched."));
            }
        }

        @Test
        public void verifiesWithCustomMatcherViaStaticDsl() {
            testClient.get("/custom-verify", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)RequestPatternBuilder.forCustomMatcher((ValueMatcher)new RequestMatcherExtension(){

                public MatchResult match(Request request, Parameters parameters) {
                    return MatchResult.of((boolean)request.getUrl().equals("/custom-verify"));
                }
            }));
        }

        @Test
        public void removesEventsById() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List initialServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)initialServeEvents.size(), (Matcher)Matchers.is((Object)3));
            WireMock.removeServeEvent((UUID)((ServeEvent)initialServeEvents.get(0)).getId());
            WireMock.removeServeEvent((UUID)((ServeEvent)initialServeEvents.get(2)).getId());
            List finalServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)finalServeEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)finalServeEvents.get(0)).getRequest().header("My-Header").firstValue(), (Matcher)Matchers.is((Object)"two"));
        }

        @Test
        public void doesNothingWhenAttemptingToRemoveANonExistentServeEvent() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List initialServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)initialServeEvents.size(), (Matcher)Matchers.is((Object)3));
            WireMock.removeServeEvent((UUID)UUID.randomUUID());
            List finalServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)finalServeEvents.size(), (Matcher)Matchers.is((Object)3));
        }

        @Test
        public void removesEventsPerSuppliedFilter() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List removedEvents = WireMock.removeServeEvents((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/one")).withHeader("My-Header", WireMock.equalTo((String)"two")));
            MatcherAssert.assertThat((Object)removedEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)removedEvents.get(0)).getRequest().header("My-Header").firstValue(), (Matcher)Matchers.is((Object)"two"));
            List serveEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)2));
            ServeEvent event1 = WireMatchers.findServeEventWithUrl(serveEvents, "/one");
            MatcherAssert.assertThat((Object)event1.getRequest().header("My-Header").firstValue(), (Matcher)Matchers.is((Object)"one"));
            ServeEvent event2 = WireMatchers.findServeEventWithUrl(serveEvents, "/two");
            MatcherAssert.assertThat((Object)event2, (Matcher)Matchers.notNullValue());
        }

        @Test
        public void returnsEmptyListWhenNoEventsMatchedForRemoval() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List removedEvents = WireMock.removeServeEvents((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/one")).withHeader("My-Header", WireMock.equalTo((String)"wrong")));
            MatcherAssert.assertThat((Object)removedEvents.size(), (Matcher)Matchers.is((Object)0));
            List serveEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)3));
        }

        @Test
        public void removesEventsAssociatedWithStubsMatchingMetadata() {
            WireMock.stubFor((MappingBuilder)WireMock.get((String)"/with-metadata").withMetadata(Metadata.metadata().list("tags", new Object[]{"delete-me"})));
            WireMock.stubFor((MappingBuilder)WireMock.get((String)"/without-metadata"));
            testClient.get("/with-metadata", new TestHttpHeader[0]);
            testClient.get("/without-metadata", new TestHttpHeader[0]);
            List removedServeEvents = WireMock.removeEventsByStubMetadata((StringValuePattern)WireMock.matchingJsonPath((String)"$.tags[0]", (StringValuePattern)WireMock.equalTo((String)"delete-me")));
            MatcherAssert.assertThat((Object)removedServeEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)removedServeEvents.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/with-metadata"));
            List serveEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/without-metadata"));
        }
    }
}

