/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.Network;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;

public class WarDeploymentParameterAcceptanceTest {
    private Server jetty;
    private WireMockTestClient testClient;

    @After
    public void cleanup() throws Exception {
        this.jetty.stop();
        WireMock.configure();
    }

    @Test
    public void testCustomMapping() throws Exception {
        this.init(TestFiles.sampleWarRootDir() + "/src/main/webappCustomMapping", "/mapping");
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/war/stub")).willReturn(WireMock.aResponse().withStatus(200).withBody("War stub OK")));
        MatcherAssert.assertThat((Object)this.testClient.get("/wiremock/mapping/war/stub", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"War stub OK"));
    }

    @Test
    public void testLimitedRequestJournal() throws Exception {
        this.init(TestFiles.sampleWarRootDir() + "/src/main/webappLimitedRequestJournal", "");
        this.testClient.get("/wiremock/request1", new TestHttpHeader[0]);
        this.testClient.get("/wiremock/request2", new TestHttpHeader[0]);
        this.testClient.get("/wiremock/request3", new TestHttpHeader[0]);
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request1")));
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request2")));
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request3")));
    }

    private void init(String webInfPath, String mappingPath) throws Exception {
        int port = Network.findFreePort();
        this.jetty = new Server(port);
        WebAppContext context = new WebAppContext(webInfPath, "/wiremock");
        this.jetty.setHandler((Handler)context);
        this.jetty.start();
        WireMock.configureFor((String)"localhost", (int)port, (String)("/wiremock" + mappingPath));
        this.testClient = new WireMockTestClient(port);
    }
}

