/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0017\tYr+\u001b:f\u001b>\u001c7nU2bY\u0006\f5mY3qi\u0006t7-\u001a+fgRT!a\u0001\u0003\u0002\u0011]L'/Z7pG.T!!\u0002\u0004\u0002\u0017Q|W.Y6fQV\u00148\u000f\u001e\u0006\u0003\u000f!\taaZ5uQV\u0014'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001a\u0001\n\u0003I\u0012AD<je\u0016lunY6TKJ4XM]\u000b\u00025A\u0011acG\u0005\u00039\t\u0011abV5sK6{7m[*feZ,'\u000fC\u0004\u001f\u0001\u0001\u0007I\u0011A\u0010\u0002%]L'/Z'pG.\u001cVM\u001d<fe~#S-\u001d\u000b\u0003A\r\u0002\"!D\u0011\n\u0005\tr!\u0001B+oSRDq\u0001J\u000f\u0002\u0002\u0003\u0007!$A\u0002yIEBaA\n\u0001!B\u0013Q\u0012aD<je\u0016lunY6TKJ4XM\u001d\u0011\t\u000f!\u0002\u0001\u0019!C\u0001S\u0005QA/Z:u\u00072LWM\u001c;\u0016\u0003)\u0002\"a\u000b\u0018\u000e\u00031R!!\f\u0002\u0002\u0017Q,7\u000f^:vaB|'\u000f^\u0005\u0003_1\u0012!cV5sK6{7m\u001b+fgR\u001cE.[3oi\"9\u0011\u0007\u0001a\u0001\n\u0003\u0011\u0014A\u0004;fgR\u001cE.[3oi~#S-\u001d\u000b\u0003AMBq\u0001\n\u0019\u0002\u0002\u0003\u0007!\u0006\u0003\u00046\u0001\u0001\u0006KAK\u0001\fi\u0016\u001cHo\u00117jK:$\b\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0003j]&$H#\u0001\u0011)\u0005YR\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0015QWO\\5u\u0015\u0005y\u0014aA8sO&\u0011\u0011\t\u0010\u0002\u0007\u0005\u00164wN]3\t\u000b\r\u0003A\u0011\u0001\u001d\u0002\u0015M$x\u000e]*feZ,'\u000f\u000b\u0002C\u000bB\u00111HR\u0005\u0003\u000fr\u0012Q!\u00114uKJDQ!\u0013\u0001\u0005\u0002a\nAGY;jY\u0012\u001cX*\u00199qS:<w+\u001b;i+JdwJ\u001c7z%\u0016\fX/Z:u\u0003:$7\u000b^1ukN|e\u000e\\=SKN\u0004xN\\:fQ\tA5\n\u0005\u0002<\u0019&\u0011Q\n\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003P\u0001\u0011\u0005\u0001(A\u000fck&dGm]'baBLgn\u001a$s_6\u001cF/\u0019;jGNKh\u000e^1yQ\tq5\nC\u0003S\u0001\u0011\u0005\u0001(A$ck&dGm]'baBLgnZ,ji\",&\u000f\\(osJ+\u0017/^3ti\u0006sGMU3ta>t7/Z,ji\"T5o\u001c8C_\u0012Lx+\u001b;i\t&\f7M]5uS\u000e\u001c\u0016n\u001a8tQ\t\t6\n")
public class WireMockScalaAcceptanceTest {
    private WireMockServer wireMockServer = null;
    private WireMockTestClient testClient = null;

    public WireMockServer wireMockServer() {
        return this.wireMockServer;
    }

    public void wireMockServer_$eq(WireMockServer x$1) {
        this.wireMockServer = x$1;
    }

    public WireMockTestClient testClient() {
        return this.testClient;
    }

    public void testClient_$eq(WireMockTestClient x$1) {
        this.testClient = x$1;
    }

    @Before
    public void init() {
        this.wireMockServer_$eq(new WireMockServer(0));
        this.wireMockServer().start();
        WireMock.configureFor((int)this.wireMockServer().port());
        this.testClient_$eq(new WireMockTestClient(this.wireMockServer().port()));
    }

    @After
    public void stopServer() {
        this.wireMockServer().stop();
    }

    @Test
    public void buildsMappingWithUrlOnlyRequestAndStatusOnlyResponse() {
        WireMock wireMock = new WireMock(this.wireMockServer().port());
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)BoxesRunTime.boxToInteger((int)this.testClient().get("/my/new/resource", new TestHttpHeader[0]).statusCode()), (Matcher)Matchers.is((Object)BoxesRunTime.boxToInteger((int)304)));
    }

    @Test
    public void buildsMappingFromStaticSyntax() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)BoxesRunTime.boxToInteger((int)this.testClient().get("/my/new/resource", new TestHttpHeader[0]).statusCode()), (Matcher)Matchers.is((Object)BoxesRunTime.boxToInteger((int)304)));
    }

    @Test
    public void buildsMappingWithUrlOnyRequestAndResponseWithJsonBodyWithDiacriticSigns() {
        WireMock wireMock = new WireMock(this.wireMockServer().port());
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withBody("{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}").withStatus(200)));
        MatcherAssert.assertThat((Object)this.testClient().get("/my/new/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}"));
    }
}

