/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class WireMockServerTests {
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void instantiationWithEmptyFileSource() throws IOException {
        WireMockConfiguration options = new WireMockConfiguration().dynamicPort().fileSource((FileSource)new SingleRootFileSource(this.tempDir.getRoot()));
        WireMockServer wireMockServer = null;
        try {
            wireMockServer = new WireMockServer((Options)options);
            wireMockServer.start();
        }
        finally {
            if (wireMockServer != null) {
                wireMockServer.stop();
            }
        }
    }

    @Test
    public void returnsOptionsWhenCallingGetOptions() {
        WireMockConfiguration options = new WireMockConfiguration();
        WireMockServer wireMockServer = new WireMockServer((Options)options);
        MatcherAssert.assertThat((Object)wireMockServer.getOptions(), (Matcher)Matchers.is((Object)options));
    }

    @Test
    public void buildsQualifiedHttpUrlFromPath() {
        WireMockServer wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort());
        wireMockServer.start();
        int port = wireMockServer.port();
        MatcherAssert.assertThat((Object)wireMockServer.url("/something"), (Matcher)Matchers.is((Object)String.format("http://localhost:%d/something", port)));
        MatcherAssert.assertThat((Object)wireMockServer.url("something"), (Matcher)Matchers.is((Object)String.format("http://localhost:%d/something", port)));
    }

    @Test
    public void buildsQualifiedHttpsUrlFromPath() {
        WireMockServer wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());
        wireMockServer.start();
        int port = wireMockServer.httpsPort();
        MatcherAssert.assertThat((Object)wireMockServer.url("/something"), (Matcher)Matchers.is((Object)String.format("https://localhost:%d/something", port)));
        MatcherAssert.assertThat((Object)wireMockServer.url("something"), (Matcher)Matchers.is((Object)String.format("https://localhost:%d/something", port)));
    }

    @Test
    public void buildsBaseHttpUrl() {
        WireMockServer wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort());
        wireMockServer.start();
        int port = wireMockServer.port();
        MatcherAssert.assertThat((Object)wireMockServer.baseUrl(), (Matcher)Matchers.is((Object)String.format("http://localhost:%d", port)));
    }

    @Test
    public void buildsBaseHttpsUrl() {
        WireMockServer wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());
        wireMockServer.start();
        int port = wireMockServer.httpsPort();
        MatcherAssert.assertThat((Object)wireMockServer.baseUrl(), (Matcher)Matchers.is((Object)String.format("https://localhost:%d", port)));
    }

    @Test
    public void supportsRecordingProgrammaticallyWithoutHeaderMatching() {
        WireMockServer wireMockServer = new WireMockServer(0, (FileSource)new SingleRootFileSource(this.tempDir.getRoot()), false, new ProxySettings("proxy.company.com", 0));
        wireMockServer.start();
        wireMockServer.enableRecordMappings((FileSource)new SingleRootFileSource(this.tempDir.getRoot() + "/mappings"), (FileSource)new SingleRootFileSource(this.tempDir.getRoot() + "/__files"));
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/something")).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockTestClient client = new WireMockTestClient(wireMockServer.port());
        MatcherAssert.assertThat((Object)client.get("http://localhost:" + wireMockServer.port() + "/something", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

