/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class XmlHandlingAcceptanceTest {
    @Rule
    public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new ResponseTemplateTransformer(false)}));
    @Rule
    public WireMockRule externalDtdServer = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)));
    WireMockTestClient client;

    @Before
    public void init() {
        this.client = new WireMockTestClient(this.wm.port());
        this.externalDtdServer.stubFor(WireMock.get((String)"/dodgy.dtd").willReturn(WireMock.ok((String)"<!ELEMENT shiftydata (#PCDATA)>").withHeader("Content-Type", new String[]{"application/xml-dtd"})));
    }

    @Test
    public void doesNotDownloadExternalDtdDocumentsWhenMatchingOnEqualToXml() {
        String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE things [\n<!ENTITY % sp SYSTEM \"http://localhost:" + this.externalDtdServer.port() + "/dodgy.dtd\">\n" + "%sp;\n" + "]>\n" + "\n" + "<things><shiftydata>123</shiftydata></things>";
        this.wm.stubFor(WireMock.post((String)"/xml-match").withRequestBody((ContentPattern)WireMock.equalToXml((String)xml)).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.postXml("/xml-match", xml, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        this.externalDtdServer.verify(0, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
    }

    @Test
    public void doesNotDownloadExternalDtdDocumentsWhenMatchingXPath() {
        String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE things [\n<!ENTITY % sp SYSTEM \"http://localhost:" + this.externalDtdServer.port() + "/dodgy.dtd\">\n" + "%sp;\n" + "]>\n" + "\n" + "<things><shiftydata>123</shiftydata></things>";
        this.wm.stubFor(WireMock.post((String)"/xpath-match").withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//shiftydata")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.postXml("/xpath-match", xml, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        this.externalDtdServer.verify(0, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
    }

    @Test
    public void doesNotDownloadExternalDtdDocumentsWhenEvaluatingXPathInTemplate() {
        String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE things [\n<!ENTITY % sp SYSTEM \"http://localhost:" + this.externalDtdServer.port() + "/dodgy.dtd\">\n" + "%sp;\n" + "]>\n" + "\n" + "<things><shiftydata>123</shiftydata></things>";
        this.wm.stubFor(WireMock.post((String)"/xpath-template").willReturn(WireMock.ok((String)"{{xPath request.body '//shiftydata/text()'}}").withTransformers(new String[]{"response-template"})));
        MatcherAssert.assertThat((Object)this.client.postXml("/xpath-template", xml, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        this.externalDtdServer.verify(0, WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
    }

    @Test
    public void doesNotAttemptToValidateXmlAgainstDtdWhenMatchingOnEqualToXml() {
        String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE things [\n<!ENTITY % sp SYSTEM \"http://localhost:" + this.externalDtdServer.port() + "/dodgy.dtd\">\n" + "%sp;\n" + "]>\n" + "\n" + "<badly-formed-things/>";
        this.wm.stubFor(WireMock.post((String)"/bad-xml-match").withRequestBody((ContentPattern)WireMock.equalToXml((String)xml)).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.postXml("/bad-xml-match", xml, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void doesNotAttemptToValidateXmlAgainstDtdWhenMatchingOnXPath() {
        String xml = "<?xml version=\"1.0\"?>\n<!DOCTYPE things [\n<!ENTITY % sp SYSTEM \"http://localhost:" + this.externalDtdServer.port() + "/dodgy.dtd\">\n" + "%sp;\n" + "]>\n" + "\n" + "<badly-formed-things/>";
        this.wm.stubFor(WireMock.post((String)"/bad-xpath-match").withRequestBody((ContentPattern)WireMock.matchingXPath((String)"/badly-formed-things")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.postXml("/bad-xpath-match", xml, new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

