/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminUriTemplate;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class AdminUriTemplateTest {
    @Test
    public void extractsSinglePathParameter() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}");
        PathParams pathParams = template.parse("/things/11-22-33");
        MatcherAssert.assertThat((Object)pathParams.get((Object)"id"), (Matcher)Matchers.is((Object)"11-22-33"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsIllegalArgumentExceptionIfAttemptingParsingOnNonMatchingUrl() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}");
        template.parse("/things/stuff/11-22-33");
    }

    @Test
    public void matchesWhenUrlIsEquivalentToTemplate() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/otherthings/12378"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void nonMatchWhenUrlIsShorterThanTemplate() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/otherthings"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void nonMatchWhenUrlPartIsMismatch() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/other-stuff/1234"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void rendersWithParameters() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        PathParams pathParams = new PathParams().add("id", "123").add("subId", "456");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/123/otherthings/456"));
    }

    @Test
    public void rendersWithoutParameters() {
        AdminUriTemplate template = new AdminUriTemplate("/things/stuff");
        String path = template.render(PathParams.empty());
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/stuff"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsErrorWhenNotAllParametersAreBound() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        template.render(new PathParams().add("id", "123"));
    }
}

