/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.admin.tasks.OldRemoveStubMappingTask;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;

public class RemoveStubMappingTaskTest {
    private static final StubMapping MOCK_MAPPING = new StubMapping(null, new ResponseDefinition());
    private Mockery context;
    private Admin mockAdmin;
    private Request mockRequest;
    private OldRemoveStubMappingTask removeStubMappingTask;

    @Before
    public void setUp() {
        this.context = new Mockery();
        this.mockAdmin = (Admin)this.context.mock(Admin.class);
        this.mockRequest = (Request)this.context.mock(Request.class);
        this.removeStubMappingTask = new OldRemoveStubMappingTask();
    }

    @Test
    public void delegatesSavingMappingsToAdmin() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Request)this.oneOf(RemoveStubMappingTaskTest.this.mockRequest)).getBodyAsString();
                this.will(1.returnValue((Object)StubMapping.buildJsonStringFor((StubMapping)MOCK_MAPPING)));
                ((Admin)this.oneOf(RemoveStubMappingTaskTest.this.mockAdmin)).removeStubMapping((StubMapping)this.with(1.any(StubMapping.class)));
            }
        });
        this.removeStubMappingTask.execute(this.mockAdmin, this.mockRequest, PathParams.empty());
    }

    @Test
    public void returnsOKResponse() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Request)this.oneOf(RemoveStubMappingTaskTest.this.mockRequest)).getBodyAsString();
                this.will(2.returnValue((Object)StubMapping.buildJsonStringFor((StubMapping)MOCK_MAPPING)));
                ((Admin)this.oneOf(RemoveStubMappingTaskTest.this.mockAdmin)).removeStubMapping((StubMapping)this.with(2.any(StubMapping.class)));
            }
        });
        ResponseDefinition response = this.removeStubMappingTask.execute(this.mockAdmin, this.mockRequest, PathParams.empty());
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }
}

