/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.admin.tasks.SaveMappingsTask;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SaveMappingsTaskTest {
    private Mockery context;
    private Admin mockAdmin;
    private Request mockRequest;
    private SaveMappingsTask saveMappingsTask;

    @Before
    public void setUp() {
        this.context = new Mockery();
        this.mockAdmin = (Admin)this.context.mock(Admin.class);
        this.mockRequest = (Request)this.context.mock(Request.class);
        this.saveMappingsTask = new SaveMappingsTask();
    }

    @Test
    public void delegatesSavingMappingsToAdmin() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Admin)this.oneOf(SaveMappingsTaskTest.this.mockAdmin)).saveMappings();
            }
        });
        this.saveMappingsTask.execute(this.mockAdmin, this.mockRequest, PathParams.empty());
    }

    @Test
    public void returnsOkResponse() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Admin)this.oneOf(SaveMappingsTaskTest.this.mockAdmin)).saveMappings();
            }
        });
        ResponseDefinition response = this.saveMappingsTask.execute(this.mockAdmin, this.mockRequest, PathParams.empty());
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }
}

