/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class CountMatchingStrategyTest {
    @Test
    public void shouldMatchLessThanCorrectly() {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN, 5);
        MatcherAssert.assertThat((Object)countStrategy.match(3), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)countStrategy.match(5), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)countStrategy.match(7), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldMatchLessThanOrEqualCorrectly() {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, 5);
        MatcherAssert.assertThat((Object)countStrategy.match(3), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)countStrategy.match(5), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)countStrategy.match(7), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldMatchEqualToCorrectly() {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, 5);
        MatcherAssert.assertThat((Object)countStrategy.match(3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)countStrategy.match(5), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)countStrategy.match(7), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldMatchGreaterThanOrEqualCorrectly() {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, 5);
        MatcherAssert.assertThat((Object)countStrategy.match(3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)countStrategy.match(5), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)countStrategy.match(7), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldMatchGreaterThanCorrectly() {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN, 5);
        MatcherAssert.assertThat((Object)countStrategy.match(3), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)countStrategy.match(5), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)countStrategy.match(7), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldCorrectlyObtainFriendlyNameForLessThanMode() throws Exception {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN, 5);
        MatcherAssert.assertThat((Object)countStrategy.toString(), (Matcher)Matchers.is((Object)"Less than 5"));
    }

    @Test
    public void shouldCorrectlyObtainFriendlyNameForLessThanOrEqualMode() throws Exception {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, 5);
        MatcherAssert.assertThat((Object)countStrategy.toString(), (Matcher)Matchers.is((Object)"Less than or exactly 5"));
    }

    @Test
    public void shouldCorrectlyObtainFriendlyNameForEqualMode() throws Exception {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, 5);
        MatcherAssert.assertThat((Object)countStrategy.toString(), (Matcher)Matchers.is((Object)"Exactly 5"));
    }

    @Test
    public void shouldCorrectlyObtainFriendlyNameForGreaterThanOrEqualMode() throws Exception {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, 5);
        MatcherAssert.assertThat((Object)countStrategy.toString(), (Matcher)Matchers.is((Object)"More than or exactly 5"));
    }

    @Test
    public void shouldCorrectlyObtainFriendlyNameForGreaterThanMode() throws Exception {
        CountMatchingStrategy countStrategy = new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN, 5);
        MatcherAssert.assertThat((Object)countStrategy.toString(), (Matcher)Matchers.is((Object)"More than 5"));
    }
}

