/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ResponseDefinitionBuilderTest {
    @Test
    public void withTransformerParameterShouldNotChangeOriginalTransformerParametersValue() {
        ResponseDefinition originalResponseDefinition = ResponseDefinitionBuilder.responseDefinition().withTransformerParameter("name", (Object)"original").build();
        ResponseDefinition transformedResponseDefinition = ResponseDefinitionBuilder.like((ResponseDefinition)originalResponseDefinition).but().withTransformerParameter("name", (Object)"changed").build();
        MatcherAssert.assertThat((Object)originalResponseDefinition.getTransformerParameters().getString("name"), (Matcher)Matchers.is((Object)"original"));
        MatcherAssert.assertThat((Object)transformedResponseDefinition.getTransformerParameters().getString("name"), (Matcher)Matchers.is((Object)"changed"));
    }

    @Test
    public void likeShouldCreateCompleteResponseDefinitionCopy() throws Exception {
        ResponseDefinition originalResponseDefinition = ResponseDefinitionBuilder.responseDefinition().withStatus(200).withStatusMessage("OK").withBody("some body").withBase64Body(Base64.encodeBase64String((byte[])"some body".getBytes(Charsets.UTF_8))).withBodyFile("some_body.json").withHeader("some header", new String[]{"some value"}).withFixedDelay(Integer.valueOf(100)).withUniformRandomDelay(1, 2).withChunkedDribbleDelay(1, 1000).withFault(Fault.EMPTY_RESPONSE).withTransformers(new String[]{"some transformer"}).withTransformerParameter("some param", (Object)"some value").build();
        ResponseDefinition copiedResponseDefinition = ResponseDefinitionBuilder.like((ResponseDefinition)originalResponseDefinition).build();
        MatcherAssert.assertThat((Object)copiedResponseDefinition, (Matcher)Matchers.is((Object)originalResponseDefinition));
    }
}

