/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ArrayFunctions;
import org.junit.Assert;
import org.junit.Test;

public class ArrayFunctionsTest {
    private final Integer[] empty = new Integer[0];

    @Test
    public void concatEmptyAndEmpty() {
        Assert.assertArrayEquals((Object[])this.empty, (Object[])ArrayFunctions.concat((Object[])this.empty, (Object[])this.empty));
    }

    @Test
    public void concatNonEmptyAndEmpty() {
        Object[] first = new Integer[]{1, 2};
        Object[] result = (Integer[])ArrayFunctions.concat((Object[])first, (Object[])this.empty);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])result);
        first[0] = 10;
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])result);
    }

    @Test
    public void concatEmptyAndNonEmpty() {
        Object[] second = new Integer[]{1, 2};
        Object[] result = (Integer[])ArrayFunctions.concat((Object[])this.empty, (Object[])second);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])result);
        second[0] = 10;
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2}, (Object[])result);
    }

    @Test
    public void concatNonEmptyAndNonEmpty() {
        Object[] first = new Integer[]{1, 2};
        Object[] second = new Integer[]{3, 4};
        Object[] result = (Integer[])ArrayFunctions.concat((Object[])first, (Object[])second);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3, 4}, (Object[])result);
        first[0] = 10;
        second[0] = 30;
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3, 4}, (Object[])result);
    }

    @Test
    public void prependNullAndEmpty() {
        Assert.assertArrayEquals((Object[])new Integer[]{null}, (Object[])ArrayFunctions.prepend(null, (Object[])this.empty));
    }

    @Test
    public void prependSomeAndEmpty() {
        Object[] result = (Integer[])ArrayFunctions.prepend((Object)1, (Object[])this.empty);
        Assert.assertArrayEquals((Object[])new Integer[]{1}, (Object[])result);
    }

    @Test
    public void prependNullAndNonEmpty() {
        Object[] second = new Integer[]{1, 2};
        Object[] result = (Integer[])ArrayFunctions.prepend(null, (Object[])second);
        Assert.assertArrayEquals((Object[])new Integer[]{null, 1, 2}, (Object[])result);
        second[0] = 10;
        Assert.assertArrayEquals((Object[])new Integer[]{null, 1, 2}, (Object[])result);
    }

    @Test
    public void prependSomeAndNonEmpty() {
        Object[] second = new Integer[]{2, 3};
        Object[] result = (Integer[])ArrayFunctions.prepend((Object)1, (Object[])second);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])result);
        second[0] = 30;
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])result);
    }
}

