/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ContentTypesTest {
    @Test
    public void detectsTextTypesCorrectlyFromFileExtension() {
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"txt"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"json"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"xml"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"html"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"htm"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"yaml"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromExtension((String)"csv"));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromExtension((String)"jpg"));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromExtension((String)"png"));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromExtension(null));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromExtension((String)""));
    }

    @Test
    public void detectsTextTypesCorrectlyFromMimeType() {
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/plain"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/html"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/json"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"some-preamble; application/json"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/blah.something+json"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/xml"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/xml"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"text/xml; utf-8"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/csv"));
        Assert.assertTrue((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/x-www-form-urlencoded"));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/octet-stream"));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromMimeType((String)"image/jpeg"));
        Assert.assertFalse((boolean)ContentTypes.determineIsTextFromMimeType((String)"application/pdf"));
    }

    @Test
    public void detectsTextTypesCorrectlyFromExtensionOrMimeType() {
        Assert.assertTrue((boolean)ContentTypes.determineIsText((String)"txt", (String)"text/plain"));
        Assert.assertTrue((boolean)ContentTypes.determineIsText((String)"xml", (String)""));
        Assert.assertTrue((boolean)ContentTypes.determineIsText((String)"json", null));
        Assert.assertFalse((boolean)ContentTypes.determineIsText((String)"png", null));
        Assert.assertFalse((boolean)ContentTypes.determineIsText(null, (String)"image/jpeg"));
    }

    @Test
    public void correctlyDeterminesFileExtensionWhenDotsInPath() {
        String fileExtension = ContentTypes.determineFileExtension((String)"http://some.host/path.with.dots/and/several/segments", (ContentTypeHeader)ContentTypeHeader.absent(), (byte[])new byte[0]);
        MatcherAssert.assertThat((Object)fileExtension, (Matcher)Matchers.is((Object)"txt"));
    }

    @Test
    public void correctlyDeterminesFileExtensionFromUrl() {
        String fileExtension = ContentTypes.determineFileExtension((String)"http://some.host/path.with.dots/image.png", (ContentTypeHeader)ContentTypeHeader.absent(), (byte[])new byte[0]);
        MatcherAssert.assertThat((Object)fileExtension, (Matcher)Matchers.is((Object)"png"));
    }
}

