/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.JettySettings;
import com.google.common.base.Optional;
import org.junit.Assert;
import org.junit.Test;

public class JettySettingsTest {
    private static final int number = 1234;
    private static final long longNumber = Long.MAX_VALUE;

    @Test
    public void testBuilderWithValues() {
        JettySettings.Builder builder = JettySettings.Builder.aJettySettings();
        builder.withAcceptors(Integer.valueOf(1234)).withAcceptQueueSize(Integer.valueOf(1234)).withRequestHeaderSize(Integer.valueOf(1234)).withStopTimeout(Long.valueOf(Long.MAX_VALUE));
        JettySettings jettySettings = builder.build();
        this.ensurePresent((Optional<Integer>)jettySettings.getAcceptors());
        this.ensurePresent((Optional<Integer>)jettySettings.getAcceptQueueSize());
        this.ensurePresent((Optional<Integer>)jettySettings.getRequestHeaderSize());
        this.ensureLongPresent((Optional<Long>)jettySettings.getStopTimeout());
    }

    @Test
    public void testBuilderWithNoValues() {
        JettySettings.Builder builder = JettySettings.Builder.aJettySettings();
        JettySettings jettySettings = builder.build();
        Assert.assertFalse((boolean)jettySettings.getAcceptors().isPresent());
        Assert.assertFalse((boolean)jettySettings.getAcceptQueueSize().isPresent());
        Assert.assertFalse((boolean)jettySettings.getRequestHeaderSize().isPresent());
        Assert.assertFalse((boolean)jettySettings.getStopTimeout().isPresent());
    }

    private void ensurePresent(Optional<Integer> optional) {
        Assert.assertTrue((boolean)optional.isPresent());
        Assert.assertEquals((Object)new Integer(1234), (Object)optional.get());
    }

    private void ensureLongPresent(Optional<Long> optional) {
        Assert.assertTrue((boolean)optional.isPresent());
        Assert.assertEquals((Object)new Long(Long.MAX_VALUE), (Object)optional.get());
    }
}

