/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ProxySettings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ProxySettingsTest {
    public static final String PROXYVIA_URL = "a.proxyvia.url";
    public static final int PROXYVIA_PORT = 8080;
    public static final String PROXYVIA_URL_WITH_PORT = "a.proxyvia.url:8080";
    public static final int DEFAULT_PORT = 80;
    public static final String USER = "user";
    public static final String PASSWORD = "pass";

    @Test
    public void shouldRetrieveProxySettingsFromString() {
        ProxySettings proxySettings = ProxySettings.fromString((String)PROXYVIA_URL_WITH_PORT);
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)8080));
    }

    @Test
    public void shouldUse80AsDefaultPort() {
        ProxySettings proxySettings = ProxySettings.fromString((String)PROXYVIA_URL);
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)80));
    }

    @Test
    public void shouldRecognizeUrlWithTrailingSlashIsPresent() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"a.proxyvia.url:8080/");
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)8080));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfPortIsNotRecognized() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"a.proxyvia.url:80a");
    }

    @Test
    public void shouldRetrieveProxyCredsFromUrl() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"user:pass@a.proxyvia.url");
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)80));
        MatcherAssert.assertThat((Object)proxySettings.getUsername(), (Matcher)Matchers.is((Object)USER));
        MatcherAssert.assertThat((Object)proxySettings.getPassword(), (Matcher)Matchers.is((Object)PASSWORD));
    }

    @Test
    public void shouldRetrieveProxyCredsAndPortFromUrl() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"user:pass@a.proxyvia.url:8080");
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)8080));
        MatcherAssert.assertThat((Object)proxySettings.getUsername(), (Matcher)Matchers.is((Object)USER));
        MatcherAssert.assertThat((Object)proxySettings.getPassword(), (Matcher)Matchers.is((Object)PASSWORD));
    }

    @Test
    public void shouldRetrieveProxyCredsWithOnlyUserFromUrl() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"user@a.proxyvia.url");
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)80));
        MatcherAssert.assertThat((Object)proxySettings.getUsername(), (Matcher)Matchers.is((Object)USER));
        MatcherAssert.assertThat((Object)proxySettings.getPassword(), (Matcher)Matchers.isEmptyOrNullString());
    }

    @Test
    public void shouldAllowProtocol() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"http://a.proxyvia.url:8080");
        MatcherAssert.assertThat((Object)proxySettings.host(), (Matcher)Matchers.is((Object)PROXYVIA_URL));
        MatcherAssert.assertThat((Object)proxySettings.port(), (Matcher)Matchers.is((Object)8080));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowHttpsProtocol() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"https://a.proxyvia.url:8080");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfUrlIsInvalid() {
        ProxySettings proxySettings = ProxySettings.fromString((String)"ul:invalid:80");
    }
}

