/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.SafeNames;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SafeNamesTest {
    @Test
    public void generatesNameFromStubNameWhenPresent() {
        StubMapping mapping = WireMock.get((String)"/named").withName("This is a NAMED stub").willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)SafeNames.makeSafeFileName((StubMapping)mapping), (Matcher)Matchers.is((Object)("this-is-a-named-stub-" + mapping.getId() + ".json")));
    }

    @Test
    public void generatesNameFromStubUrlWhenNameNotPresent() {
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.urlMatching((String)"/named/([0-9]*)/things")).willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)SafeNames.makeSafeFileName((StubMapping)mapping), (Matcher)Matchers.is((Object)("named0-9things-" + mapping.getId() + ".json")));
    }

    @Test
    public void generatesNameWhenStubUrlIsAnyAndNameNotPresent() {
        StubMapping mapping = WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()).build();
        MatcherAssert.assertThat((Object)SafeNames.makeSafeFileName((StubMapping)mapping), (Matcher)Matchers.is((Object)(mapping.getId() + ".json")));
    }

    @Test
    public void generatesNameFromNameWithCharactersSafeForFilenames() {
        String output = SafeNames.makeSafeName((String)"\u1e84\u01cf\u0154e m\u020e\u010c\u01e8s it!");
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"wire-mocks-it"));
    }

    @Test
    public void doesNothingWhenAlreadySafe() {
        String input = "wire-mocks__it--123-4";
        String output = SafeNames.makeSafeName((String)input);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)input));
    }

    @Test
    public void generatesNameFromUrlPathWithCharactersSafeForFilenames() {
        String output = SafeNames.makeSafeNameFromUrl((String)"/hello/1/2/3__!/\u1eae\u010c\u0116--ace/\u00a5$$/$/and/\u00bf?");
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.is((Object)"hello_1_2_3___ace--ace___and"));
    }

    @Test
    public void truncatesWhenResultingNameOver200Chars() {
        String output = SafeNames.makeSafeNameFromUrl((String)"/hello/1/2/3__!/\u1eae\u010c\u0116--ace/\u00a5$$/$/andverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuffandverylongstuff/\u00bf?");
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)200));
    }
}

