/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.security.NotAuthorisedException;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SingleRootFileSourceTest {
    public static final String ROOT_PATH = TestFiles.filePath("filesource");

    @Test
    public void listsTextFilesRecursively() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        List files = fileSource.listFilesRecursively();
        MatcherAssert.assertThat((Object)files, WireMatchers.hasExactlyIgnoringOrder(WireMatchers.fileNamed("one"), WireMatchers.fileNamed("two"), WireMatchers.fileNamed("three"), WireMatchers.fileNamed("four"), WireMatchers.fileNamed("five"), WireMatchers.fileNamed("six"), WireMatchers.fileNamed("seven"), WireMatchers.fileNamed("eight"), WireMatchers.fileNamed("deepfile.json")));
    }

    @Test
    public void writesTextFileEvenWhenRootIsARelativePath() throws IOException {
        String relativeRootPath = "./target/tmp/";
        FileUtils.forceMkdir((File)new File(relativeRootPath));
        SingleRootFileSource fileSource = new SingleRootFileSource(relativeRootPath);
        Path fileAbsolutePath = Paths.get(relativeRootPath, new String[0]).toAbsolutePath().resolve("myFile");
        fileSource.writeTextFile(fileAbsolutePath.toString(), "stuff");
        MatcherAssert.assertThat((Object)Files.exists(fileAbsolutePath, new LinkOption[0]), (Matcher)Matchers.is((Object)true));
    }

    @Test(expected=RuntimeException.class)
    public void listFilesRecursivelyThrowsExceptionWhenRootIsNotDir() {
        SingleRootFileSource fileSource = new SingleRootFileSource("src/test/resources/filesource/one");
        fileSource.listFilesRecursively();
    }

    @Test(expected=RuntimeException.class)
    public void writeThrowsExceptionWhenRootIsNotDir() {
        SingleRootFileSource fileSource = new SingleRootFileSource("src/test/resources/filesource/one");
        fileSource.writeTextFile("thing", "stuff");
    }

    @Test(expected=NotAuthorisedException.class)
    public void writeTextFileThrowsExceptionWhenGivenRelativePathNotUnderRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        fileSource.writeTextFile("..", "stuff");
    }

    @Test(expected=NotAuthorisedException.class)
    public void writeTextFileThrowsExceptionWhenGivenAbsolutePathNotUnderRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        String badPath = Paths.get("..", "not-under-root").toAbsolutePath().toString();
        fileSource.writeTextFile(badPath, "stuff");
    }

    @Test(expected=NotAuthorisedException.class)
    public void writeBinaryFileThrowsExceptionWhenGivenRelativePathNotUnderRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        fileSource.writeBinaryFile("..", "stuff".getBytes());
    }

    @Test(expected=NotAuthorisedException.class)
    public void writeBinaryFileThrowsExceptionWhenGivenAbsolutePathNotUnderRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        String badPath = Paths.get("..", "not-under-root").toAbsolutePath().toString();
        fileSource.writeBinaryFile(badPath, "stuff".getBytes());
    }

    @Test(expected=NotAuthorisedException.class)
    public void deleteThrowsExceptionWhenGivenPathNotUnderRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        String badPath = Paths.get("..", "not-under-root").toAbsolutePath().toString();
        fileSource.deleteFile(badPath);
    }

    @Test(expected=NotAuthorisedException.class)
    public void readBinaryFileThrowsExceptionWhenRelativePathIsOutsideRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        fileSource.getBinaryFileNamed("../illegal.file");
    }

    @Test(expected=NotAuthorisedException.class)
    public void readTextFileThrowsExceptionWhenRelativePathIsOutsideRoot() {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        fileSource.getTextFileNamed("../illegal.file");
    }

    @Test(expected=NotAuthorisedException.class)
    public void readBinaryFileThrowsExceptionWhenAbsolutePathIsOutsideRoot() throws Exception {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        String badPath = new File(ROOT_PATH, "../illegal.file").getCanonicalPath();
        fileSource.getBinaryFileNamed(badPath);
    }

    @Test(expected=NotAuthorisedException.class)
    public void readTextFileThrowsExceptionWhenAbsolutePathIsOutsideRoot() throws Exception {
        SingleRootFileSource fileSource = new SingleRootFileSource(ROOT_PATH);
        String badPath = new File(ROOT_PATH, "../illegal.file").getCanonicalPath();
        fileSource.getTextFileNamed(badPath);
    }
}

