/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.TextFile;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TextFileTest {
    @Test
    public void returnsPathToFileOnLinuxSystems() throws Exception {
        Assume.assumeFalse((String)"This test can only be run on non-Windows its behaviour is OS specific", (boolean)SystemUtils.IS_OS_WINDOWS);
        TextFile textFile = new TextFile(new URI("file://home/bob/myfile.txt"));
        String path = textFile.getPath();
        Assert.assertEquals((Object)"/home/bob/myfile.txt", (Object)path);
    }

    @Test
    public void returnsPathToFileOnWindowsSystems() throws Exception {
        Assume.assumeTrue((String)"This test can only be run on Windows because File uses FileSystem in its constructor and its behaviour is OS specific", (boolean)SystemUtils.IS_OS_WINDOWS);
        TextFile textFile = new TextFile(new URI("file:/C:/Users/bob/myfile.txt"));
        Path path = Paths.get(textFile.getPath(), new String[0]);
        Assert.assertEquals((Object)Paths.get("C:/Users/bob/myfile.txt", new String[0]), (Object)path);
    }
}

