/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class UrlsTest {
    private Map<String, QueryParameter> params;

    @Test
    public void copesWithEqualsInParamValues() {
        this.params = Urls.splitQuery((URI)URI.create("/thing?param1=one&param2=one==two=three"));
        MatcherAssert.assertThat((Object)this.params.get("param1").firstValue(), (Matcher)Matchers.is((Object)"one"));
        MatcherAssert.assertThat((Object)this.params.get("param2").firstValue(), (Matcher)Matchers.is((Object)"one==two=three"));
    }

    @Test
    public void returnsEmptyStringsAsValuesWhenOnlyKeysArePresent() {
        this.params = Urls.splitQuery((URI)URI.create("/thing?param1&param2&param3"));
        MatcherAssert.assertThat((Object)this.params.get("param1").firstValue(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)this.params.get("param2").firstValue(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)this.params.get("param3").firstValue(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void supportsMultiValuedParameters() {
        this.params = Urls.splitQuery((URI)URI.create("/thing?param1=1&param2=two&param1=2&param1=3"));
        MatcherAssert.assertThat((Object)this.params.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.params.get("param1").isSingleValued(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.params.get("param1").values(), (Matcher)Matchers.hasItems((Object[])new String[]{"1", "2", "3"}));
    }

    @Test
    public void doesNotAttemptToDoubleDecodeSplitQueryString() {
        URI url = URI.create("/thing?q=a%25b");
        Map query = Urls.splitQuery((URI)url);
        MatcherAssert.assertThat((Object)((QueryParameter)query.get("q")).firstValue(), (Matcher)Matchers.is((Object)"a%b"));
    }

    @Test
    public void returnsEmptyStringForEmptyUrlPathParts() {
        MatcherAssert.assertThat((Object)Urls.urlToPathParts((URI)URI.create("/")), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)Urls.urlToPathParts((URI)URI.create("http://www.wiremock.org/")), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void returnsNonDelimitedStringForUrlWithOnePathPart() {
        String pathParts = Urls.urlToPathParts((URI)URI.create("/foo?param=value"));
        MatcherAssert.assertThat((Object)pathParts, (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void returnsDelimitedStringForUrlWithTwoPathParts() {
        String pathParts = Urls.urlToPathParts((URI)URI.create("/foo/bar/?param=value"));
        MatcherAssert.assertThat((Object)pathParts, (Matcher)Matchers.is((Object)"foo-bar"));
    }

    @Test
    public void returnsNonDelimitedStringForUrlWithMoreThanTwoPathParts() {
        String pathParts = Urls.urlToPathParts((URI)URI.create("/foo/bar/zoo/wire/mock?param=value"));
        MatcherAssert.assertThat((Object)pathParts, (Matcher)Matchers.is((Object)"foo-bar-zoo-wire-mock"));
    }

    @Test
    public void splitsQueryFromUrl() {
        Map query = Urls.splitQueryFromUrl((String)"/a/b?one=1&one=11&two=2");
        List oneValues = ((QueryParameter)query.get("one")).values();
        MatcherAssert.assertThat((Object)oneValues, (Matcher)Matchers.hasItems((Object[])new String[]{"1", "11"}));
        MatcherAssert.assertThat((Object)oneValues, (Matcher)Matchers.hasItem((Object)"11"));
        MatcherAssert.assertThat((Object)((QueryParameter)query.get("two")).firstValue(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void splitsQueryFromUrlWithTrailingSlash() {
        Map query = Urls.splitQueryFromUrl((String)"/a/b/?one=1&one=11&two=2");
        List oneValues = ((QueryParameter)query.get("one")).values();
        MatcherAssert.assertThat((Object)oneValues, (Matcher)Matchers.hasItems((Object[])new String[]{"1", "11"}));
        MatcherAssert.assertThat((Object)oneValues, (Matcher)Matchers.hasItem((Object)"11"));
        MatcherAssert.assertThat((Object)((QueryParameter)query.get("two")).firstValue(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void splitQueryFromUrlHandlesUrlThatEndsWithQuestionMark() {
        Map query = Urls.splitQueryFromUrl((String)"/a/b/?");
        MatcherAssert.assertThat((Object)query.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void splitQueryFromUrlReturnsEmptyWhenNoQuery() {
        Map query = Urls.splitQueryFromUrl((String)"/a/b");
        MatcherAssert.assertThat((Object)query.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void splitQueryFromUrlReturnsEmptyWhenTrailingSlashAndNoQuery() {
        Map query = Urls.splitQueryFromUrl((String)"/a/b/");
        MatcherAssert.assertThat((Object)query.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getsThePathFromAUrlWithAQueryString() {
        MatcherAssert.assertThat((Object)Urls.getPath((String)"/one/two/3?q=a"), (Matcher)Matchers.is((Object)"/one/two/3"));
    }

    @Test
    public void getsThePathFromAUrlWithoutAQueryString() {
        MatcherAssert.assertThat((Object)Urls.getPath((String)"/one/two/3"), (Matcher)Matchers.is((Object)"/one/two/3"));
    }

    @Test
    public void getsThePathFromAUrlWithATrailingSlashAndQueryString() {
        MatcherAssert.assertThat((Object)Urls.getPath((String)"/one/two/3/?q=a"), (Matcher)Matchers.is((Object)"/one/two/3/"));
    }

    @Test
    public void getsThePathFromAUrlWithRootPathAndQuery() {
        MatcherAssert.assertThat((Object)Urls.getPath((String)"/?q=a"), (Matcher)Matchers.is((Object)"/"));
    }

    @Test
    public void getsThePathFromAUrlWithJustAQuery() {
        MatcherAssert.assertThat((Object)Urls.getPath((String)"?q=a"), (Matcher)Matchers.is((Object)""));
    }
}

