/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.common.xml.XmlDocument;
import com.github.tomakehurst.wiremock.common.xml.XmlNode;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class XmlTest {
    @Test
    public void findsSimpleXmlNodesByXPath() {
        String xml = "<?xml version=\"1.0\"?>\n<things>\n    <thing>1</thing>\n    <thing>2</thing>\n</things>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        ListOrSingle nodes = xmlDocument.findNodes("//things/thing/text()");
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((XmlNode)nodes.get(0)).toString(), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)((XmlNode)nodes.get(1)).toString(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void findsNamespacedXmlNodeByXPath() {
        String xml = "<?xml version=\"1.0\"?>\n<things xmlns:s=\"https://stuff.biz\" id=\"1\">\n    <stuff id=\"1\"/>\n    <fl:fluff xmlns:fl=\"https://fluff.abc\" id=\"2\" fl:group=\"555\">\n        <fl:inner id=\"123\" fl:code=\"D1\">Innards</fl:inner>\n        <fl:inner>More Innards</fl:inner>\n    </fl:fluff>\n</things>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        ListOrSingle nodes = xmlDocument.findNodes("/things/fluff");
        MatcherAssert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(((XmlNode)nodes.get(0)).getAttributes().get("id"), (Matcher)Matchers.is((Object)"2"));
        MatcherAssert.assertThat(((XmlNode)nodes.get(0)).getAttributes().get("fl:group"), (Matcher)Matchers.is((Object)"555"));
    }

    @Test
    public void prettyPrintsDocument() {
        String xml = "<one><two><three name='3'/></two></one>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        MatcherAssert.assertThat((Object)xmlDocument.toString(), (Matcher)Matchers.is((Object)"<one>\n  <two>\n    <three name=\"3\"/>\n  </two>\n</one>\n"));
    }

    @Test
    public void prettyPrintsNodeAttributeValue() {
        String xml = "<one><two><three name='3'/></two></one>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        ListOrSingle nodes = xmlDocument.findNodes("//three/@name");
        MatcherAssert.assertThat((Object)((XmlNode)nodes.getFirst()).toString(), (Matcher)Matchers.is((Object)"3"));
    }

    @Test
    public void prettyPrintsNodeTextValue() {
        String xml = "<one><two>2</two></one>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        ListOrSingle nodes = xmlDocument.findNodes("/one/two/text()");
        MatcherAssert.assertThat((Object)((XmlNode)nodes.getFirst()).toString(), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void prettyPrintsNodeXml() {
        String xml = "<one><two><three name=\"3\"/></two></one>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        ListOrSingle nodes = xmlDocument.findNodes("/one/two");
        MatcherAssert.assertThat((Object)((XmlNode)nodes.getFirst()).toString(), (Matcher)Matchers.is((Object)"<two>\n  <three name=\"3\"/>\n</two>"));
    }

    @Test
    public void printsNamespacedXmlWhenPrefixDeclarationNotInScope() {
        String xml = "<?xml version=\"1.0\"?>\n<things xmlns:s=\"https://stuff.biz\" id=\"1\">\n    <stuff id=\"1\"/>\n    <fl:fluff xmlns:fl=\"https://fluff.abc\" id=\"2\">\n        <fl:inner id=\"123\" fl:code=\"D1\">Innards</fl:inner>\n        <fl:inner>More Innards</fl:inner>\n    </fl:fluff>\n</things>";
        XmlDocument xmlDocument = Xml.parse((String)xml);
        ListOrSingle xmlNodes = xmlDocument.findNodes("/things/fluff/inner[@id=\"123\"]");
        MatcherAssert.assertThat((Object)xmlNodes.toString(), (Matcher)Matchers.is((Object)"<fl:inner fl:code=\"D1\" id=\"123\">Innards</fl:inner>"));
    }
}

