/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.google.common.base.Optional;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class WireMockConfigurationTest {
    @Test
    public void testJettyStopTimeout() {
        Long expectedStopTimeout = 500L;
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.wireMockConfig().jettyStopTimeout(expectedStopTimeout);
        Optional jettyStopTimeout = wireMockConfiguration.jettySettings().getStopTimeout();
        MatcherAssert.assertThat((Object)jettyStopTimeout.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)jettyStopTimeout.get(), (Matcher)Matchers.is((Object)expectedStopTimeout));
    }

    @Test
    public void testJettyStopTimeoutNotSet() {
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.wireMockConfig();
        Optional jettyStopTimeout = wireMockConfiguration.jettySettings().getStopTimeout();
        MatcherAssert.assertThat((Object)jettyStopTimeout.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldUseQueuedThreadPoolByDefault() {
        int maxThreads = 20;
        WireMockConfiguration wireMockConfiguration = WireMockConfiguration.wireMockConfig().containerThreads(Integer.valueOf(maxThreads));
        QueuedThreadPool threadPool = (QueuedThreadPool)wireMockConfiguration.threadPoolFactory().buildThreadPool((Options)wireMockConfiguration);
        MatcherAssert.assertThat((Object)threadPool.getMaxThreads(), (Matcher)Matchers.is((Object)maxThreads));
    }
}

