/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.crypto;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.crypto.CertificateSpecification;
import com.github.tomakehurst.wiremock.crypto.X509CertificateVersion;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class X509CertificateSpecification
implements CertificateSpecification {
    private final X509CertificateVersion version;
    private final X500Name subject;
    private final X500Name issuer;
    private final Date notBefore;
    private final Date notAfter;

    public X509CertificateSpecification(X509CertificateVersion version, String subject, String issuer, Date notBefore, Date notAfter) throws IOException {
        this.version = Objects.requireNonNull(version);
        this.subject = new X500Name(Objects.requireNonNull(subject));
        this.issuer = new X500Name(Objects.requireNonNull(issuer));
        this.notBefore = Objects.requireNonNull(notBefore);
        this.notAfter = Objects.requireNonNull(notAfter);
    }

    @Override
    public X509Certificate certificateFor(KeyPair keyPair) throws CertificateException, InvalidKeyException, SignatureException {
        try {
            SecureRandom random = new SecureRandom();
            X509CertInfo info = new X509CertInfo();
            info.set("version", this.version.getVersion());
            try {
                info.set("subject", this.subject);
            }
            catch (CertificateException ignore) {
                info.set("subject", new CertificateSubjectName(this.subject));
            }
            try {
                info.set("issuer", this.issuer);
            }
            catch (CertificateException ignore) {
                info.set("issuer", new CertificateIssuerName(this.issuer));
            }
            info.set("validity", new CertificateValidity(this.notBefore, this.notAfter));
            info.set("key", new CertificateX509Key(keyPair.getPublic()));
            info.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, random)));
            info.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid)));
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(keyPair.getPrivate(), "SHA256withRSA");
            info.set("algorithmID.algorithm", cert.get("x509.algorithm"));
            cert = new X509CertImpl(info);
            cert.sign(keyPair.getPrivate(), "SHA256withRSA");
            cert.verify(keyPair.getPublic());
            return cert;
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
            return (X509Certificate)Exceptions.throwUnchecked((Throwable)e, null);
        }
    }
}

