/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.requestfilter;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.extension.requestfilter.FieldTransformer;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestWrapper;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.MockMultipart;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RequestWrapperTest {
    @Test
    public void changesTheRequestMethod() {
        MockRequest request = MockRequest.mockRequest().method(RequestMethod.GET);
        Request wrappedRequest = RequestWrapper.create().setMethod(RequestMethod.POST).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getMethod(), (Matcher)Matchers.is((Object)RequestMethod.POST));
    }

    @Test
    public void transformsTheUrl() {
        MockRequest request = MockRequest.mockRequest().url("/original-path?one=1&two=2");
        Request wrappedRequest = RequestWrapper.create().transformAbsoluteUrl((FieldTransformer)new FieldTransformer<String>(){

            public String transform(String existingUrl) {
                return existingUrl.replace("my.domain", "wiremock.org").replace("/original-path", "/new-path");
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getUrl(), (Matcher)Matchers.is((Object)"/new-path?one=1&two=2"));
        MatcherAssert.assertThat((Object)wrappedRequest.getAbsoluteUrl(), (Matcher)Matchers.is((Object)"http://wiremock.org/new-path?one=1&two=2"));
    }

    @Test
    public void transformsAUrlWithNoPath() {
        MockRequest request = MockRequest.mockRequest().url("");
        Request wrappedRequest = RequestWrapper.create().transformAbsoluteUrl((FieldTransformer)new FieldTransformer<String>(){

            public String transform(String existingUrl) {
                return existingUrl.replace("my.domain", "wiremock.org");
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getUrl(), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)wrappedRequest.getAbsoluteUrl(), (Matcher)Matchers.is((Object)"http://wiremock.org"));
    }

    @Test
    public void addsSpecifiedHeaders() {
        MockRequest request = MockRequest.mockRequest().header("One", "1");
        Request wrappedRequest = RequestWrapper.create().addHeader("Two", new String[]{"2"}).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getHeaders().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)wrappedRequest.getHeader("Two"), (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void removesSpecifiedHeaders() {
        MockRequest request = MockRequest.mockRequest().header("One", "1");
        Request wrappedRequest = RequestWrapper.create().removeHeader("One").wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getHeaders().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void transformsSpecifiedHeaders() {
        MockRequest request = MockRequest.mockRequest().header("One", "1").header("Two", "2", "3");
        Request wrappedRequest = RequestWrapper.create().transformHeader("One", (FieldTransformer)new FieldTransformer<List<String>>(){

            public List<String> transform(List<String> headerValues) {
                return FluentIterable.from(headerValues).transform((Function)new Function<String, String>(){

                    public String apply(String headerValue) {
                        return headerValue + "1";
                    }
                }).toList();
            }
        }).transformHeader("two", (FieldTransformer)new FieldTransformer<List<String>>(){

            public List<String> transform(List<String> headerValues) {
                return FluentIterable.from(headerValues).transform((Function)new Function<String, String>(){

                    public String apply(String headerValue) {
                        return headerValue + "2";
                    }
                }).toList();
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getHeader("One"), (Matcher)Matchers.is((Object)"11"));
        HttpHeader headerTwo = wrappedRequest.header("Two");
        MatcherAssert.assertThat(headerTwo.values().get(0), (Matcher)Matchers.is((Object)"22"));
        MatcherAssert.assertThat(headerTwo.values().get(1), (Matcher)Matchers.is((Object)"32"));
    }

    @Test
    public void addsSpecifiedCookies() {
        MockRequest request = MockRequest.mockRequest().cookie("One", "1");
        Request wrappedRequest = RequestWrapper.create().addCookie("Two", new Cookie("2")).addCookie("Three", new Cookie("3")).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getCookies().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Cookie)wrappedRequest.getCookies().get("Two")).firstValue(), (Matcher)Matchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)((Cookie)wrappedRequest.getCookies().get("Three")).firstValue(), (Matcher)Matchers.is((Object)"3"));
    }

    @Test
    public void removesSpecifiedCookies() {
        MockRequest request = MockRequest.mockRequest().cookie("One", "1").cookie("Two", "2").cookie("Three", "3");
        Request wrappedRequest = RequestWrapper.create().removeCookie("Two").wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getCookies().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(wrappedRequest.getCookies().get("Two"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void transformsSpecifiedCookies() {
        MockRequest request = MockRequest.mockRequest().cookie("One", "1");
        Request wrappedRequest = RequestWrapper.create().transformCookie("One", (FieldTransformer)new FieldTransformer<Cookie>(){

            public Cookie transform(Cookie cookie) {
                return new Cookie(cookie.firstValue() + "1");
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)((Cookie)wrappedRequest.getCookies().get("One")).firstValue(), (Matcher)Matchers.is((Object)"11"));
    }

    @Test
    public void transformsAStringBody() {
        MockRequest request = MockRequest.mockRequest().body("One");
        Request wrappedRequest = RequestWrapper.create().transformBody((FieldTransformer)new FieldTransformer<Body>(){

            public Body transform(Body existingBody) {
                String newValue = existingBody.asString().replace("One", "Two");
                return new Body(newValue);
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getBodyAsString(), (Matcher)Matchers.is((Object)"Two"));
        MatcherAssert.assertThat((Object)wrappedRequest.getBodyAsBase64(), (Matcher)Matchers.is((Object)Encoding.encodeBase64((byte[])"Two".getBytes())));
    }

    @Test
    public void transformsABinaryBody() {
        byte[] initialBytes = new byte[]{1, 2, 3};
        final byte[] finalBytes = new byte[]{4, 5, 6};
        MockRequest request = MockRequest.mockRequest().body(initialBytes);
        Request wrappedRequest = RequestWrapper.create().transformBody((FieldTransformer)new FieldTransformer<Body>(){

            public Body transform(Body existingBody) {
                return new Body(finalBytes);
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getBody(), (Matcher)Matchers.is((Object)finalBytes));
        MatcherAssert.assertThat((Object)wrappedRequest.getBodyAsBase64(), (Matcher)Matchers.is((Object)Encoding.encodeBase64((byte[])finalBytes)));
    }

    @Test
    public void transformsMultiparts() {
        MockRequest request = MockRequest.mockRequest().part(MockMultipart.mockPart().name("one").body("1")).part(MockMultipart.mockPart().name("two").body("2"));
        Request wrappedRequest = RequestWrapper.create().transformParts((FieldTransformer)new FieldTransformer<Request.Part>(){

            public Request.Part transform(Request.Part existingPart) {
                return existingPart.getName().equals("one") ? MockMultipart.mockPart().name("one").body("1111") : MockMultipart.mockPart().name("two").body("2222");
            }
        }).wrap((Request)request);
        MatcherAssert.assertThat((Object)wrappedRequest.getPart("one").getBody().asString(), (Matcher)Matchers.is((Object)"1111"));
        MatcherAssert.assertThat((Object)wrappedRequest.getPart("two").getBody().asString(), (Matcher)Matchers.is((Object)"2222"));
        MatcherAssert.assertThat((Object)wrappedRequest.getParts(), (Matcher)Matchers.hasItem((Object)MockMultipart.mockPart().name("one").body("1111")));
    }
}

