/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.DateOffset;
import java.text.DateFormat;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DateOffsetTest {
    static final DateFormat ISO8601 = new ISO8601DateFormat();

    @Test
    public void parsesSecondsOffset() {
        DateOffset offset = new DateOffset("7 seconds");
        MatcherAssert.assertThat((Object)offset.getTimeUnit(), (Matcher)Matchers.is((Object)DateOffset.Unit.SECONDS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void parsesMinutesOffset() {
        DateOffset offset = new DateOffset("78 minutes");
        MatcherAssert.assertThat((Object)offset.getTimeUnit(), (Matcher)Matchers.is((Object)DateOffset.Unit.MINUTES));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)78));
    }

    @Test
    public void parsesHoursOffset() {
        DateOffset offset = new DateOffset("-12 hours");
        MatcherAssert.assertThat((Object)offset.getTimeUnit(), (Matcher)Matchers.is((Object)DateOffset.Unit.HOURS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)-12));
    }

    @Test
    public void parsesDaysOffset() {
        DateOffset offset = new DateOffset("1 days");
        MatcherAssert.assertThat((Object)offset.getTimeUnit(), (Matcher)Matchers.is((Object)DateOffset.Unit.DAYS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void parsesMonthsOffset() {
        DateOffset offset = new DateOffset("-12 months");
        MatcherAssert.assertThat((Object)offset.getTimeUnit(), (Matcher)Matchers.is((Object)DateOffset.Unit.MONTHS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)-12));
    }

    @Test
    public void parsesYearsOffset() {
        DateOffset offset = new DateOffset("101 years");
        MatcherAssert.assertThat((Object)offset.getTimeUnit(), (Matcher)Matchers.is((Object)DateOffset.Unit.YEARS));
        MatcherAssert.assertThat((Object)offset.getAmount(), (Matcher)Matchers.is((Object)101));
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionWhenUnparseableStringProvided() {
        new DateOffset("101");
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionWhenUnparseableUnitProvided() {
        new DateOffset("101 squillions");
    }

    @Test
    public void offsetsProvidedDateByConfiguredAmount() throws Exception {
        DateOffset offset = new DateOffset("3 days");
        Date startingDate = ISO8601.parse("2018-04-16T12:01:01Z");
        Date finalDate = offset.shift(startingDate);
        MatcherAssert.assertThat((Object)ISO8601.format(finalDate), (Matcher)Matchers.is((Object)"2018-04-19T12:01:01Z"));
    }
}

