/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;

public abstract class HandlebarsHelperTestBase {
    protected ResponseTemplateTransformer transformer;
    protected RenderCache renderCache;
    protected static final String FAIL_GRACEFULLY_MSG = "Handlebars helper should fail gracefully and show the issue directly in the response.";

    @Before
    public void initRenderCache() {
        this.transformer = new ResponseTemplateTransformer(true);
        this.renderCache = new RenderCache();
    }

    protected <T> void testHelperError(Helper<T> helper, T content, String pathExpression, Matcher<String> expectation) {
        try {
            MatcherAssert.assertThat((Object)((String)this.renderHelperValue(helper, content, pathExpression)), expectation);
        }
        catch (IOException e) {
            Assert.fail((String)FAIL_GRACEFULLY_MSG);
        }
    }

    protected <R, C> R renderHelperValue(Helper<C> helper, C content, String parameter) throws IOException {
        return (R)helper.apply(content, this.createOptions(parameter));
    }

    protected <T> void testHelper(Helper<T> helper, T content, String optionParam, String expected) throws IOException {
        this.testHelper(helper, content, optionParam, (Matcher<String>)Matchers.is((Object)expected));
    }

    protected <T> void testHelper(Helper<T> helper, T content, String optionParam, Matcher<String> expected) throws IOException {
        MatcherAssert.assertThat((Object)helper.apply(content, this.createOptions(optionParam)).toString(), expected);
    }

    protected Options createOptions(String optionParam) {
        return this.createOptions(optionParam, this.renderCache);
    }

    protected Options createOptions(String optionParam, RenderCache renderCache) {
        Context context = Context.newBuilder(null).combine("renderCache", (Object)renderCache).build();
        return new Options(null, null, null, context, null, null, new Object[]{optionParam}, null, new ArrayList(0));
    }
}

