/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsSoapHelper;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.testsupport.NoFileSource;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class HandlebarsSoapHelperTest
extends HandlebarsHelperTestBase {
    private HandlebarsSoapHelper helper;
    private ResponseTemplateTransformer transformer;

    @Before
    public void init() {
        this.helper = new HandlebarsSoapHelper();
        this.transformer = new ResponseTemplateTransformer(true);
    }

    @Test
    public void extractsASimpleBodyValue() throws IOException {
        this.testHelper(this.helper, "<Envelope><Body><test>success</test></Body></Envelope>", "/test/text()", "success");
    }

    @Test
    public void rendersASimpleValue() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/soap").body("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope/\"><soap:Body><m:a><m:test>success</m:test></m:a></soap:Body></soap:Envelope>"), WireMock.aResponse().withBody("<test>{{soapXPath request.body '/a/test/text()'}}</test>").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"<test>success</test>"));
    }

    @Test
    public void negativeTestResponseTemplate() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/soap").body("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope/\"><soap:Body><m:a><m:test>success</m:test></m:a></soap:Body></soap:Envelope>"), WireMock.aResponse().withBody("<test>{{soapXPath request.body '/b/test'}}</test>").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"<test></test>"));
    }
}

