/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseDateHelper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class ParseDateHelperTest {
    private static final DateFormat df = new ISO8601DateFormat();
    private static final DateFormat localDf = new SimpleDateFormat("yyyy-MM-dd");
    private ParseDateHelper helper;

    @Before
    public void init() {
        this.helper = new ParseDateHelper();
    }

    @Test
    public void parsesAnISO8601DateWhenNoFormatSpecified() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of();
        String inputDate = "2018-05-01T01:02:03Z";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = df.parse(inputDate);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void parsesDateWithSuppliedFormat() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"format", (Object)"dd/MM/yyyy");
        String inputDate = "01/02/2003";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = localDf.parse("2003-02-01");
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    private Object render(String context, ImmutableMap<String, Object> optionsHash) throws IOException {
        return this.helper.apply(context, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build());
    }
}

