/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AdminRequestHandlerTest {
    private Mockery context;
    private WireMockServer wm;
    private WireMockTestClient client;

    @Before
    public void init() {
        this.context = new Mockery();
    }

    @After
    public void cleanup() {
        if (this.wm != null) {
            this.wm.stop();
        }
    }

    @Test
    public void shouldLogInfoOnRequest() throws UnsupportedEncodingException {
        final Notifier notifier = (Notifier)this.context.mock(Notifier.class);
        this.wm = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().notifier(notifier));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
        String postHeaderABCName = "ABC";
        String postHeaderABCValue = "abc123";
        String postBody = "{\n    \"request\": {\n        \"method\": \"GET\",\n        \"url\": \"/some/thing\"\n    },\n    \"response\": {\n        \"status\": 200,\n        \"body\": \"Hello world!\",\n        \"headers\": {\n            \"Content-Type\": \"text/plain\"\n        }\n    }\n}";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Notifier)this.one(notifier)).info((String)this.with(Matchers.allOf((Matcher)Matchers.containsString((String)"Admin request received:\n127.0.0.1 - POST /mappings\n"), (Matcher)Matchers.containsString((String)"ABC: [abc123]\n"), (Matcher)Matchers.containsString((String)"{\n    \"request\": {\n        \"method\": \"GET\",\n        \"url\": \"/some/thing\"\n    },\n    \"response\": {\n        \"status\": 200,\n        \"body\": \"Hello world!\",\n        \"headers\": {\n            \"Content-Type\": \"text/plain\"\n        }\n    }\n}"))));
            }
        });
        this.client.post("/__admin/mappings", (HttpEntity)new StringEntity("{\n    \"request\": {\n        \"method\": \"GET\",\n        \"url\": \"/some/thing\"\n    },\n    \"response\": {\n        \"status\": 200,\n        \"body\": \"Hello world!\",\n        \"headers\": {\n            \"Content-Type\": \"text/plain\"\n        }\n    }\n}"), TestHttpHeader.withHeader("ABC", "abc123"));
        this.context.assertIsSatisfied();
    }
}

