/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.Body;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class BodyTest {
    @Test
    public void constructsFromBytes() {
        Body body = Body.fromOneOf((byte[])"this content".getBytes(), (String)"not this content", (JsonNode)new IntNode(1), (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"this content"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void constructsFromString() {
        Body body = Body.fromOneOf(null, (String)"this content", (JsonNode)new IntNode(1), (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"this content"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void constructsFromJson() {
        Body body = Body.fromOneOf(null, null, (JsonNode)new IntNode(1), (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void constructsFromBase64() {
        byte[] base64Encoded = Base64.encodeBase64((byte[])"this content".getBytes());
        String encodedText = Strings.stringFromBytes((byte[])base64Encoded);
        Body body = Body.fromOneOf(null, null, null, (String)encodedText);
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"this content"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void bodyAsJson() {
        JsonNode jsonContent = Json.node((String)"{\"name\":\"wiremock\",\"isCool\":true}");
        Body body = Body.fromOneOf(null, null, (JsonNode)jsonContent, (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asJson(), (Matcher)Matchers.is((Object)jsonContent));
    }
}

