/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class CookieTest {
    @Test
    public void serialisesCorrectlyWithSingleValue() {
        Cookie cookie = new Cookie("my_cookie", new String[]{"one"});
        MatcherAssert.assertThat((Object)Json.write((Object)cookie), (Matcher)Matchers.is((Object)"\"one\""));
    }

    @Test
    public void serialisesCorrectlyWithManyValues() {
        Cookie cookie = new Cookie("my_cookie", new String[]{"one", "two", "three"});
        MatcherAssert.assertThat((Object)Json.write((Object)cookie), WireMatchers.equalToJson("[\"one\", \"two\", \"three\"]"));
    }

    @Test
    public void serialisesCorrectlyWithNoValues() {
        Cookie cookie = new Cookie("my_cookie", new String[0]);
        MatcherAssert.assertThat((Object)Json.write((Object)cookie), WireMatchers.equalToJson("[]"));
    }

    @Test
    public void deserialisesCorrectlyWithSingleValue() {
        String json = "\"one\"";
        Cookie cookie = (Cookie)Json.read((String)json, Cookie.class);
        MatcherAssert.assertThat((Object)cookie.getValues().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)cookie.getValue(), (Matcher)Matchers.is((Object)"one"));
    }

    @Test
    public void deserialisesCorrectlyWithManyValues() {
        String json = "[\"one\", \"two\", \"three\"]";
        Cookie cookie = (Cookie)Json.read((String)json, Cookie.class);
        MatcherAssert.assertThat((Object)cookie.getValues().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)cookie.getValues(), (Matcher)Matchers.hasItems((Object[])new String[]{"one", "two", "three"}));
    }

    @Test
    public void deserialisesCorrectlyWithNoValues() {
        String json = "[]";
        Cookie cookie = (Cookie)Json.read((String)json, Cookie.class);
        MatcherAssert.assertThat((Object)cookie.getValues().size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)cookie.isAbsent(), (Matcher)Matchers.is((Object)true));
    }
}

