/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.http.HttpClientFactoryCertificateVerificationTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpClientFactoryAcceptsTrustedCertificatesTest
extends HttpClientFactoryCertificateVerificationTest {
    @Parameterized.Parameters(name="{index}: trusted={0}, certificateCN={1}, validCertificate={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TRUST_NOBODY, "localhost", true}, {Collections.singletonList("other.com"), "localhost", true}, {Collections.singletonList("localhost"), "other.com", true}, {Collections.singletonList("localhost"), "other.com", false}, {Collections.singletonList("localhost"), "localhost", true}, {Collections.singletonList("localhost"), "localhost", false});
    }

    @Test
    public void certificatesAreAccepted() throws Exception {
        this.server.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.aResponse().withBody("Hello World")));
        HttpResponse response = this.client.execute((HttpUriRequest)new HttpGet(this.server.url("/whatever")));
        String result = HttpClientUtils.getEntityAsStringAndCloseStream((HttpResponse)response);
        Assert.assertEquals((Object)"Hello World", (Object)result);
    }

    public HttpClientFactoryAcceptsTrustedCertificatesTest(List<String> trustedHosts, String certificateCN, boolean validCertificate) {
        super(trustedHosts, certificateCN, validCertificate);
    }
}

