/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactoryCertificateVerificationTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpClientFactoryRejectsUntrustedCertificatesTest
extends HttpClientFactoryCertificateVerificationTest {
    @Parameterized.Parameters(name="{index}: trusted={0}, certificateCN={1}, validCertificate={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TRUST_NOBODY, "other.com", true}, {TRUST_NOBODY, "other.com", false}, {TRUST_NOBODY, "localhost", false}, {Collections.singletonList("other.com"), "other.com", true}, {Collections.singletonList("other.com"), "other.com", false}, {Collections.singletonList("other.com"), "localhost", false});
    }

    @Test
    public void certificatesAreRejectedAsExpected() {
        this.server.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.aResponse().withBody("Hello World")));
        Assert.assertThrows(SSLException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Exception {
                HttpClientFactoryRejectsUntrustedCertificatesTest.this.client.execute((HttpUriRequest)new HttpGet(HttpClientFactoryRejectsUntrustedCertificatesTest.this.server.url("/whatever")));
            }
        });
    }

    public HttpClientFactoryRejectsUntrustedCertificatesTest(List<String> trustedHosts, String certificateCN, boolean validCertificate) {
        super(trustedHosts, certificateCN, validCertificate);
    }
}

