/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.crypto.InMemoryKeyStore;
import com.github.tomakehurst.wiremock.crypto.Secret;
import com.github.tomakehurst.wiremock.crypto.X509CertificateSpecification;
import com.github.tomakehurst.wiremock.crypto.X509CertificateVersion;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ProxyResponseRendererTest {
    @Rule
    public WireMockRule origin = new WireMockRule((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort().keystorePath(this.generateKeystore().getAbsolutePath()));
    private final ProxyResponseRenderer proxyResponseRenderer = this.buildProxyResponseRenderer(false);

    @Test
    public void acceptsAnyCertificateForStandardProxying() {
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.reverseProxyServeEvent("/proxied");
        Response response = this.proxyResponseRenderer.render(serveEvent);
        Assert.assertEquals((Object)response.getBodyAsString(), (Object)"Result");
    }

    @Test
    public void rejectsSelfSignedCertificateForForwardProxyingByDefault() {
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        Response response = this.proxyResponseRenderer.render(serveEvent);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getBodyAsString(), (Matcher)StringStartsWith.startsWith((String)("SSL failure trying to make a proxied request from WireMock to " + this.origin.url("/proxied"))));
        MatcherAssert.assertThat((Object)response.getBodyAsString(), (Matcher)StringContains.containsString((String)"unable to find valid certification path to requested target"));
    }

    @Test
    public void acceptsSelfSignedCertificateForForwardProxyingIfTrustAllProxyTargets() {
        ProxyResponseRenderer trustAllProxyResponseRenderer = this.buildProxyResponseRenderer(true);
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        Response response = trustAllProxyResponseRenderer.render(serveEvent);
        Assert.assertEquals((Object)response.getBodyAsString(), (Object)"Result");
    }

    private ServeEvent reverseProxyServeEvent(String path) {
        return this.serveEvent(path, false);
    }

    private ServeEvent forwardProxyServeEvent(String path) {
        return this.serveEvent(path, true);
    }

    private ServeEvent serveEvent(String path, boolean isBrowserProxyRequest) {
        LoggedRequest loggedRequest = new LoggedRequest(path, this.origin.url(path), RequestMethod.GET, "127.0.0.1", new HttpHeaders(), new HashMap(), isBrowserProxyRequest, new Date(), new byte[0], null);
        ResponseDefinition responseDefinition = WireMock.aResponse().proxiedFrom(this.origin.baseUrl()).build();
        responseDefinition.setOriginalRequest((Request)loggedRequest);
        return ServeEvent.of((LoggedRequest)loggedRequest, (ResponseDefinition)responseDefinition, (StubMapping)new StubMapping());
    }

    private File generateKeystore() throws Exception {
        InMemoryKeyStore ks = new InMemoryKeyStore(InMemoryKeyStore.KeyStoreType.JKS, new Secret("password"));
        X509CertificateSpecification certificateSpecification = new X509CertificateSpecification(X509CertificateVersion.V3, "CN=localhost", "CN=wiremock.org", new Date(), new Date(System.currentTimeMillis() + 31536000000L));
        KeyPair keyPair = this.generateKeyPair();
        ks.addPrivateKey("wiremock", keyPair, certificateSpecification.certificateFor(keyPair));
        File keystoreFile = File.createTempFile("wiremock-test", "keystore");
        ks.saveAs(keystoreFile);
        return keystoreFile;
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(1024);
        return keyGen.generateKeyPair();
    }

    private ProxyResponseRenderer buildProxyResponseRenderer(boolean trustAllProxyTargets) {
        return new ProxyResponseRenderer(ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, false, null, new GlobalSettingsHolder(), trustAllProxyTargets, Collections.emptyList());
    }
}

