/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServer;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServerFactory;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.lang.reflect.Field;
import java.util.Collections;
import org.eclipse.jetty.server.ServerConnector;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class JettyHttpServerTest {
    private Mockery context;
    private AdminRequestHandler adminRequestHandler;
    private StubRequestHandler stubRequestHandler;
    private JettyHttpServerFactory serverFactory = new JettyHttpServerFactory();

    @Before
    public void init() {
        this.context = new Mockery();
        Admin admin = (Admin)this.context.mock(Admin.class);
        this.adminRequestHandler = new AdminRequestHandler(AdminRoutes.defaults(), admin, (ResponseRenderer)new BasicResponseRenderer(), (Authenticator)new NoAuthenticator(), false, Collections.emptyList());
        this.stubRequestHandler = new StubRequestHandler((StubServer)this.context.mock(StubServer.class), (ResponseRenderer)this.context.mock(ResponseRenderer.class), admin, Collections.emptyMap(), (RequestJournal)this.context.mock(RequestJournal.class), Collections.emptyList(), false);
    }

    @Test
    public void testStopTimeout() {
        long expectedStopTimeout = 500L;
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().jettyStopTimeout(Long.valueOf(expectedStopTimeout));
        JettyHttpServer jettyHttpServer = (JettyHttpServer)this.serverFactory.buildHttpServer((Options)config, this.adminRequestHandler, this.stubRequestHandler);
        MatcherAssert.assertThat((Object)jettyHttpServer.stopTimeout(), (Matcher)Matchers.is((Object)expectedStopTimeout));
    }

    @Test
    public void testStopTimeoutNotSet() {
        long expectedStopTimeout = 1000L;
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig();
        JettyHttpServer jettyHttpServer = (JettyHttpServer)this.serverFactory.buildHttpServer((Options)config, this.adminRequestHandler, this.stubRequestHandler);
        MatcherAssert.assertThat((Object)jettyHttpServer.stopTimeout(), (Matcher)Matchers.is((Object)expectedStopTimeout));
    }

    @Test
    public void testHttpConnectorIsNullWhenHttpDisabled() throws NoSuchFieldException, IllegalAccessException {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().httpDisabled(true);
        JettyHttpServer jettyHttpServer = (JettyHttpServer)this.serverFactory.buildHttpServer((Options)config, this.adminRequestHandler, this.stubRequestHandler);
        Field httpConnectorField = JettyHttpServer.class.getDeclaredField("httpConnector");
        httpConnectorField.setAccessible(true);
        ServerConnector httpConnector = (ServerConnector)httpConnectorField.get(jettyHttpServer);
        Assert.assertNull((Object)httpConnector);
    }
}

