/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class EqualToPatternTest {
    @Test
    public void returnsANonZeroScoreForPartialMatchOnEquals() {
        StringValuePattern pattern = WireMock.equalTo((String)"matchthis");
        MatcherAssert.assertThat((Object)pattern.match((Object)"matchthisbadlydone").getDistance(), (Matcher)Matchers.is((Object)0.5));
    }

    @Test
    public void returns1ForNoMatchOnEquals() {
        StringValuePattern pattern = WireMock.equalTo((String)"matchthis");
        MatcherAssert.assertThat((Object)pattern.match((Object)"924387348975923").getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returns0ForExactMatchOnEquals() {
        StringValuePattern pattern = WireMock.equalTo((String)"matchthis");
        MatcherAssert.assertThat((Object)pattern.match((Object)"matchthis").getDistance(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void matchesCaseInsensitive() {
        StringValuePattern pattern = WireMock.equalToIgnoreCase((String)"MaTchtHis");
        MatcherAssert.assertThat((Object)pattern.match((Object)"matchthis").isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void correctlyDeserialisesEqualToFromJson() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                               \n  \"equalTo\": \"something\"    \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(EqualToPattern.class));
        MatcherAssert.assertThat((Object)stringValuePattern.getValue(), (Matcher)Matchers.is((Object)"something"));
    }

    @Test
    public void correctlyDeserialisesEqualToFromJsonWithIgnoreCase() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                              \n  \"equalTo\": \"something\",   \n  \"caseInsensitive\": true     \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(EqualToPattern.class));
        MatcherAssert.assertThat((Object)stringValuePattern.getValue(), (Matcher)Matchers.is((Object)"something"));
        MatcherAssert.assertThat((Object)((EqualToPattern)stringValuePattern).getCaseInsensitive(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void correctlySerialisesToJson() throws Exception {
        JSONAssert.assertEquals((String)"{                               \n  \"equalTo\": \"something\"    \n}", (String)Json.write((Object)new EqualToPattern("something")), (boolean)false);
    }

    @Test
    public void failsWithMeaningfulErrorWhenOperatorNotRecognised() {
        try {
            Json.read((String)"{                               \n  \"munches\": \"something\"    \n}", StringValuePattern.class);
            Assert.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(JsonException.class));
            JsonException jsonException = (JsonException)e;
            MatcherAssert.assertThat((Object)jsonException.getErrors().first().getDetail(), (Matcher)Matchers.containsString((String)"{\"munches\":\"something\"} is not a valid match operation"));
        }
    }

    @Test
    public void noMatchOnNullValue() {
        MatcherAssert.assertThat((Object)WireMock.equalTo((String)"this_thing").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }
}

