/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MatchesJsonPathPatternTest {
    private Mockery context;

    @Before
    public void init() {
        this.context = new Mockery();
    }

    @Test
    public void matchesABasicJsonPathWhenTheExpectedElementIsPresent() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.one");
        Assert.assertTrue((String)"Expected match when JSON attribute is present", (boolean)pattern.match((Object)"{ \"one\": 1 }").isExactMatch());
    }

    @Test
    public void doesNotMatchABasicJsonPathWhenTheExpectedElementIsNotPresent() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.one");
        Assert.assertFalse((String)"Expected no match when JSON attribute is absent", (boolean)pattern.match((Object)"{ \"two\": 2 }").isExactMatch());
    }

    @Test
    public void matchesOnJsonPathsWithFilters() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.numbers[?(@.number == '2')]");
        Assert.assertTrue((String)"Expected match when JSON attribute is present", (boolean)pattern.match((Object)"{ \"numbers\": [ {\"number\": 1}, {\"number\": 2} ]}").isExactMatch());
        Assert.assertFalse((String)"Expected no match when JSON attribute is absent", (boolean)pattern.match((Object)"{ \"numbers\": [{\"number\": 7} ]}").isExactMatch());
    }

    @Test
    public void matchesOnJsonPathsWithRegexFilter() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.numbers[?(@.number =~ /2/i)]");
        Assert.assertTrue((String)"Expected match when JSON attribute is present", (boolean)pattern.match((Object)"{ \"numbers\": [ {\"number\": 1}, {\"number\": 2} ]}").isExactMatch());
        Assert.assertFalse((String)"Expected no match when JSON attribute is absent", (boolean)pattern.match((Object)"{ \"numbers\": [{\"number\": 7} ]}").isExactMatch());
    }

    @Test
    public void matchesOnJsonPathsWithSizeFilter() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$[?(@.numbers.size() == 2)]");
        Assert.assertTrue((String)"Expected match when JSON attribute is present", (boolean)pattern.match((Object)"{ \"numbers\": [ {\"number\": 1}, {\"number\": 2} ]}").isExactMatch());
        Assert.assertFalse((String)"Expected no match when JSON attribute is absent", (boolean)pattern.match((Object)"{ \"numbers\": [{\"number\": 7} ]}").isExactMatch());
    }

    @Test
    public void matchesOnJsonPathsWithFiltersOnNestedObjects() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$..thingOne[?(@.innerOne == 11)]");
        Assert.assertTrue((String)"Expected match", (boolean)pattern.match((Object)"{ \"things\": { \"thingOne\": { \"innerOne\": 11 }, \"thingTwo\": 2 }}").isExactMatch());
    }

    @Test
    public void providesSensibleNotificationWhenJsonMatchFailsDueToInvalidJson() {
        this.expectInfoNotification("Warning: JSON path expression '$.something' failed to match document 'Not a JSON document' because of error 'Expected to find an object with property ['something'] in path $ but found 'java.lang.String'. This is not a json object according to the JsonProvider: 'com.jayway.jsonpath.spi.json.JsonSmartJsonProvider'.'");
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.something");
        Assert.assertFalse((String)"Expected the match to fail", (boolean)pattern.match((Object)"Not a JSON document").isExactMatch());
    }

    @Test
    public void providesSensibleNotificationWhenJsonMatchFailsDueToMissingAttributeJson() {
        this.expectInfoNotification("Warning: JSON path expression '$.something' failed to match document '{ \"nothing\": 1 }' because of error 'No results for path: $['something']'");
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.something");
        Assert.assertFalse((String)"Expected the match to fail", (boolean)pattern.match((Object)"{ \"nothing\": 1 }").isExactMatch());
    }

    @Test
    public void doesNotMatchWhenJsonPathWouldResolveToEmptyArray() {
        String json = "{\n  \"RequestDetail\" : {\n    \"ClientTag\" : \"test111\"\n  }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.RequestDetail.?(@=='test222')");
        MatchResult match = pattern.match((Object)json);
        Assert.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void noMatchOnNullValue() {
        Assert.assertThat((Object)WireMock.matchingJsonPath((String)"$..*").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void matchesNumericExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": 11\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"11"));
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesStringExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": \"eleven\"\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"eleven"));
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesBooleanExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": true\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"true"));
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesObjectExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": 11\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl", (StringValuePattern)WireMock.equalToJson((String)"{\n    \"max\": 11\n}"));
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesArrayExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": [1, 2, 3, 11]\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalToJson((String)"[1,2,3,11]"));
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesNotPresentExpressionResultAgainstAbsentValuePattern() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": true\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.min", (StringValuePattern)WireMock.absent());
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesNullExpressionResultAgainstAbsentValuePattern() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": null\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.absent());
        MatchResult match = pattern.match((Object)json);
        Assert.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void returnsTheDistanceFromTheValueMatcherWhenNotAMatch() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": \"eleven\"\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"ele"));
        MatchResult match = pattern.match((Object)json);
        Assert.assertFalse((boolean)match.isExactMatch());
        Assert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)0.5));
    }

    @Test
    public void correctlySerialises() {
        Assert.assertThat((Object)Json.write((Object)WireMock.matchingJsonPath((String)"$..thing")), WireMatchers.equalToJson("{                                \n  \"matchesJsonPath\": \"$..thing\"       \n}"));
    }

    @Test
    public void correctlySerialisesWithValuePattern() {
        Assert.assertThat((Object)Json.write((Object)WireMock.matchingJsonPath((String)"$..thing", (StringValuePattern)WireMock.containing((String)"123"))), WireMatchers.equalToJson("{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"contains\": \"123\"           \n    }                                   \n}"));
    }

    @Test
    public void correctlyDeserialises() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                         \n  \"matchesJsonPath\": \"$..thing\"       \n}", StringValuePattern.class);
        Assert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        Assert.assertThat((Object)stringValuePattern.getExpected(), (Matcher)Matchers.is((Object)"$..thing"));
    }

    @Test
    public void correctlyDeserialisesWithValuePattern() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"equalTo\": \"the value\"      \n    }                                   \n}", StringValuePattern.class);
        Assert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        Assert.assertThat((Object)stringValuePattern.getExpected(), (Matcher)Matchers.is((Object)"$..thing"));
        StringValuePattern subMatcher = ((MatchesJsonPathPattern)stringValuePattern).getValuePattern();
        Assert.assertThat((Object)subMatcher, (Matcher)Matchers.instanceOf(EqualToPattern.class));
        Assert.assertThat((Object)subMatcher.getExpected(), (Matcher)Matchers.is((Object)"the value"));
    }

    @Test
    public void correctlyDeserialisesWithAbsentValuePattern() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"absent\": \"(absent)\"        \n    }                                   \n}", StringValuePattern.class);
        Assert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        Assert.assertThat((Object)stringValuePattern.getExpected(), (Matcher)Matchers.is((Object)"$..thing"));
        StringValuePattern subMatcher = ((MatchesJsonPathPattern)stringValuePattern).getValuePattern();
        Assert.assertThat((Object)subMatcher, (Matcher)Matchers.instanceOf(AbsentPattern.class));
        Assert.assertThat((Object)subMatcher.nullSafeIsAbsent(), (Matcher)Matchers.is((Object)true));
    }

    @Test(expected=JsonException.class)
    public void throwsSensibleErrorOnDeserialisationWhenPatternIsBadlyFormedWithMissingExpression() {
        Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"express\": \"$..thing\",      \n        \"equalTo\": \"the value\"      \n    }                                   \n}", StringValuePattern.class);
    }

    @Test(expected=JsonException.class)
    public void throwsSensibleErrorOnDeserialisationWhenPatternIsBadlyFormedWithBadValuePatternName() {
        Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"badOperator\": \"the value\"  \n    }                                   \n}", StringValuePattern.class);
    }

    @Test
    public void equalsIncludesValuePattern() {
        StringValuePattern pattern1 = WireMock.matchingJsonPath((String)"$.LinkageDetails.AccountId", (StringValuePattern)WireMock.equalTo((String)"1000"));
        StringValuePattern pattern2 = WireMock.matchingJsonPath((String)"$.LinkageDetails.AccountId", (StringValuePattern)WireMock.equalTo((String)"1001"));
        StringValuePattern pattern3 = WireMock.matchingJsonPath((String)"$.LinkageDetails.AccountId", (StringValuePattern)WireMock.equalTo((String)"1000"));
        Assert.assertThat((Object)pattern1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)pattern2)));
        Assert.assertThat((Object)pattern1.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)pattern2.hashCode())));
        Assert.assertThat((Object)pattern1, (Matcher)Matchers.equalTo((Object)pattern3));
        Assert.assertThat((Object)pattern1.hashCode(), (Matcher)Matchers.equalTo((Object)pattern3.hashCode()));
    }

    private void expectInfoNotification(final String message) {
        final Notifier notifier = (Notifier)this.context.mock(Notifier.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Notifier)this.one(notifier)).info(message);
            }
        });
        LocalNotifier.set((Notifier)notifier);
    }

    @After
    public void cleanUp() {
        LocalNotifier.set(null);
    }
}

