/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class MockMultipart
implements Request.Part {
    private String name;
    private List<HttpHeader> headers = Lists.newArrayList();
    private Body body;

    public static MockMultipart mockPart() {
        return new MockMultipart();
    }

    public MockMultipart name(String name) {
        this.name = name;
        return this;
    }

    public MockMultipart headers(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public MockMultipart header(String key, String ... values) {
        this.headers.add(new HttpHeader(key, values));
        return this;
    }

    public MockMultipart body(String body) {
        this.body = new Body(body);
        return this;
    }

    public MockMultipart body(byte[] body) {
        this.body = new Body(body);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public HttpHeader getHeader(String key) {
        return this.getHeaders().getHeader(key);
    }

    public HttpHeaders getHeaders() {
        return new HttpHeaders(this.headers);
    }

    public Body getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockMultipart that = (MockMultipart)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.headers, that.headers) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.headers, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MockMultipart{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append(", body=").append(this.body);
        sb.append('}');
        return sb.toString();
    }
}

