/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.jetty9.MultipartParser;
import com.github.tomakehurst.wiremock.matching.MockMultipart;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MockRequest
implements Request {
    private String scheme = "http";
    private String host = "my.domain";
    private int port = 80;
    private String url = "/";
    private RequestMethod method = RequestMethod.ANY;
    private HttpHeaders headers = new HttpHeaders();
    private Map<String, Cookie> cookies = Maps.newHashMap();
    private byte[] body;
    private String clientIp = "1.1.1.1";
    private Collection<Request.Part> multiparts = null;

    public static MockRequest mockRequest() {
        return new MockRequest();
    }

    public MockRequest scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public MockRequest host(String host) {
        this.host = host;
        return this;
    }

    public MockRequest port(int port) {
        this.port = port;
        return this;
    }

    public MockRequest url(String url) {
        this.url = url;
        return this;
    }

    public MockRequest method(RequestMethod method) {
        this.method = method;
        return this;
    }

    public MockRequest header(String key, String ... values) {
        this.headers = this.headers.plus(new HttpHeader[]{HttpHeader.httpHeader((String)key, (String[])values)});
        return this;
    }

    public MockRequest cookie(String key, String ... values) {
        this.cookies.put(key, new Cookie(Arrays.asList(values)));
        return this;
    }

    public MockRequest body(String body) {
        this.body = body.getBytes(Charsets.UTF_8);
        return this;
    }

    public MockRequest body(byte[] body) {
        this.body = body;
        return this;
    }

    public MockRequest clientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public MockRequest parts(Collection<Request.Part> multiparts) {
        this.multiparts = multiparts;
        return this;
    }

    public MockRequest part(MockMultipart part) {
        if (this.multiparts == null) {
            this.multiparts = Lists.newArrayList();
        }
        this.multiparts.add(part);
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAbsoluteUrl() {
        return "http://my.domain" + this.url;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getHeader(String key) {
        return this.header(key).firstValue();
    }

    public HttpHeader header(final String key) {
        return (HttpHeader)Iterables.tryFind((Iterable)this.headers.all(), (Predicate)new Predicate<HttpHeader>(){

            public boolean apply(HttpHeader input) {
                return input.keyEquals(key);
            }
        }).or((Object)HttpHeader.absent((String)key));
    }

    public ContentTypeHeader contentTypeHeader() {
        return ContentTypeHeader.absent();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public boolean containsHeader(String key) {
        return this.headers.getHeader(key).isPresent();
    }

    public Set<String> getAllHeaderKeys() {
        return this.getHeaders().keys();
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public QueryParameter queryParameter(String key) {
        Map queryParams = Urls.splitQuery((URI)URI.create(this.url));
        return (QueryParameter)queryParams.get(key);
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return this.body != null ? new String(this.body) : null;
    }

    public String getBodyAsBase64() {
        return "";
    }

    public boolean isBrowserProxyRequest() {
        return false;
    }

    public Optional<Request> getOriginalRequest() {
        return Optional.absent();
    }

    public LoggedRequest asLoggedRequest() {
        return LoggedRequest.createFrom((Request)this);
    }

    public boolean isMultipart() {
        return this.getParts() != null;
    }

    public Collection<Request.Part> getParts() {
        return this.multiparts;
    }

    public Request.Part getPart(final String name) {
        return this.getParts() != null && name != null ? (Request.Part)FluentIterable.from(this.multiparts).firstMatch((Predicate)new Predicate<Request.Part>(){

            public boolean apply(Request.Part input) {
                return name.equals(input.getName());
            }
        }).get() : null;
    }

    public MockRequest multipartBody(String body) {
        ContentTypeHeader contentTypeHeader = this.headers.getContentTypeHeader();
        String contentType = contentTypeHeader.isPresent() ? contentTypeHeader.firstValue() : "multipart/form-data; boundary=BOUNDARY";
        this.multiparts = MultipartParser.parse((byte[])Strings.bytesFromString((String)body), (String)contentType);
        return this;
    }
}

