/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class MultiValuePatternTest {
    @Test
    public void returnsExactMatchForAbsentHeaderWhenRequiredAbsent() {
        Assert.assertTrue((boolean)MultiValuePattern.absent().match((MultiValue)HttpHeader.absent((String)"any-key")).isExactMatch());
    }

    @Test
    public void returnsNonMatchForPresentHeaderWhenRequiredAbsent() {
        Assert.assertFalse((boolean)MultiValuePattern.absent().match((MultiValue)HttpHeader.httpHeader((String)"the-key", (String[])new String[]{"the value"})).isExactMatch());
    }

    @Test
    public void returnsExactMatchForPresentHeaderWhenRequiredPresent() {
        Assert.assertTrue((boolean)MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"required-value")).match((MultiValue)HttpHeader.httpHeader((String)"the-key", (String[])new String[]{"required-value"})).isExactMatch());
    }

    @Test
    public void returnsNonMatchForAbsentHeaderWhenRequiredPresent() {
        MatchResult matchResult = MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"required-value")).match((MultiValue)HttpHeader.absent((String)"the-key"));
        Assert.assertFalse((boolean)matchResult.isExactMatch());
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsNonZeroDistanceWhenHeaderValuesAreSimilar() {
        MatcherAssert.assertThat((Object)MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"required-value")).match((MultiValue)HttpHeader.httpHeader((String)"any-key", (String[])new String[]{"require1234567"})).getDistance(), (Matcher)Matchers.is((Object)0.5));
    }

    @Test
    public void returnsTheBestMatchWhenSeveralValuesAreAvailableAndNoneAreExact() {
        MatcherAssert.assertThat((Object)MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"required-value")).match((MultiValue)HttpHeader.httpHeader((String)"any-key", (String[])new String[]{"require1234567", "requi12345", "1234567rrrr"})).getDistance(), (Matcher)Matchers.is((Object)0.5));
    }

    @Test
    public void returnsTheBestMatchWhenSeveralHeaderValuesAreAvailableAndOneIsExact() {
        Assert.assertTrue((boolean)MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"required-value")).match((MultiValue)HttpHeader.httpHeader((String)"any-key", (String[])new String[]{"require1234567", "required-value", "1234567rrrr"})).isExactMatch());
    }

    @Test
    public void returnsTheBestMatchWhenSeveralQueryParamValuesAreAvailableAndOneIsExact() {
        Assert.assertTrue((boolean)MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"required-value")).match((MultiValue)QueryParameter.queryParam((String)"any-key", (String[])new String[]{"require1234567", "required-value", "1234567rrrr"})).isExactMatch());
    }

    @Test
    public void correctlyRendersEqualToAsJson() throws Exception {
        String actual = Json.write((Object)MultiValuePattern.of((StringValuePattern)WireMock.equalTo((String)"something")));
        System.out.println(actual);
        JSONAssert.assertEquals((String)"{                              \n  \"equalTo\": \"something\"   \n}", (String)actual, (boolean)true);
    }

    @Test
    public void correctlyRendersAbsentAsJson() throws Exception {
        String actual = Json.write((Object)MultiValuePattern.absent());
        System.out.println(actual);
        JSONAssert.assertEquals((String)"{                   \n  \"absent\": true   \n}", (String)actual, (boolean)true);
    }
}

