/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MultipartValuePatternBuilderTest {
    @Test
    public void testBuilderDefaultType() {
        MultipartValuePattern pattern = WireMock.aMultipart((String)"name").build();
        Assert.assertTrue((boolean)pattern.isMatchAny());
        TestCase.assertFalse((boolean)pattern.isMatchAll());
    }

    @Test
    public void testBuilderAnyType() {
        MultipartValuePattern pattern = WireMock.aMultipart((String)"name").matchingType(MultipartValuePattern.MatchingType.ANY).build();
        Assert.assertTrue((boolean)pattern.isMatchAny());
        TestCase.assertFalse((boolean)pattern.isMatchAll());
    }

    @Test
    public void testBuilderAllType() {
        MultipartValuePattern pattern = WireMock.aMultipart((String)"name").matchingType(MultipartValuePattern.MatchingType.ALL).build();
        Assert.assertTrue((boolean)pattern.isMatchAll());
        TestCase.assertFalse((boolean)pattern.isMatchAny());
    }

    @Test
    public void testBuilderWithNameHeadersAndBody() {
        MultipartValuePattern pattern = WireMock.aMultipart((String)"name").withHeader("X-Header", WireMock.containing((String)"something")).withHeader("X-Other", WireMock.absent()).withBody((ContentPattern)WireMock.equalToXml((String)"<xml />")).build();
        LinkedHashMap headerPatterns = Maps.newLinkedHashMap();
        headerPatterns.put("Content-Disposition", Arrays.asList(MultiValuePattern.of((StringValuePattern)WireMock.containing((String)"name=\"name\""))));
        headerPatterns.put("X-Header", Arrays.asList(MultiValuePattern.of((StringValuePattern)WireMock.containing((String)"something"))));
        headerPatterns.put("X-Other", Arrays.asList(MultiValuePattern.of((StringValuePattern)WireMock.absent())));
        List<ContentPattern> bodyPatterns = Arrays.asList(WireMock.equalToXml((String)"<xml />"));
        MatcherAssert.assertThat(bodyPatterns, (Matcher)Matchers.everyItem((Matcher)Matchers.isIn((Collection)pattern.getBodyPatterns())));
    }

    @Test
    public void testBuilderWithNameNoHeadersAndNoBody() {
        MultipartValuePattern pattern = WireMock.aMultipart().build();
        Assert.assertNull((Object)pattern);
    }

    @Test
    public void testBuilderWithoutNameWithHeadersAndBody() {
        MultipartValuePattern pattern = WireMock.aMultipart().withHeader("X-Header", WireMock.containing((String)"something")).withHeader("X-Other", WireMock.absent()).withBody((ContentPattern)WireMock.equalToXml((String)"<xml />")).build();
        LinkedHashMap headerPatterns = Maps.newLinkedHashMap();
        headerPatterns.put("X-Header", Arrays.asList(MultiValuePattern.of((StringValuePattern)WireMock.containing((String)"something"))));
        headerPatterns.put("X-Other", Arrays.asList(MultiValuePattern.of((StringValuePattern)WireMock.absent())));
        List<ContentPattern> bodyPatterns = Arrays.asList(WireMock.equalToXml((String)"<xml />"));
        MatcherAssert.assertThat(bodyPatterns, (Matcher)Matchers.everyItem((Matcher)Matchers.isIn((Collection)pattern.getBodyPatterns())));
    }

    @Test
    public void testBuilderWithNameAndOtherContentDispositionHeaderMatcher() {
        MultipartValuePattern pattern = WireMock.aMultipart((String)"name").withHeader("Content-Disposition", WireMock.containing((String)"filename=\"something\"")).build();
        LinkedHashMap headerPatterns = Maps.newLinkedHashMap();
        headerPatterns.put("Content-Disposition", Arrays.asList(MultiValuePattern.of((StringValuePattern)WireMock.containing((String)"name=\"name\"")), MultiValuePattern.of((StringValuePattern)WireMock.containing((String)"filename=\"something\""))));
    }
}

