/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.recording.LoggedResponseDefinitionTransformer;
import org.junit.Assert;
import org.junit.Test;

public class LoggedResponseDefinitionTransformerTest {
    private LoggedResponseDefinitionTransformer aTransformer() {
        return new LoggedResponseDefinitionTransformer();
    }

    @Test
    public void applyWithEmptyHeadersAndBody() {
        LoggedResponse response = LoggedResponse.from((Response)Response.response().status(401).build());
        Assert.assertEquals((Object)ResponseDefinitionBuilder.responseDefinition().withStatus(401).build(), (Object)this.aTransformer().apply(response));
    }

    @Test
    public void applyWithTextBody() {
        LoggedResponse response = LoggedResponse.from((Response)Response.response().headers(new HttpHeaders(new HttpHeader[]{new ContentTypeHeader("text/plain")})).body("foo").build());
        ResponseDefinition expected = ResponseDefinitionBuilder.responseDefinition().withHeader("Content-Type", new String[]{"text/plain"}).withBody("foo").build();
        Assert.assertEquals((Object)expected, (Object)this.aTransformer().apply(response));
    }

    @Test
    public void applyWithBinaryBody() {
        byte[] body = new byte[]{1, 12, 3, 11, 1};
        LoggedResponse response = LoggedResponse.from((Response)Response.response().headers(new HttpHeaders(new HttpHeader[]{new ContentTypeHeader("application/octet-stream")})).body(body).build());
        ResponseDefinition expected = ResponseDefinitionBuilder.responseDefinition().withHeader("Content-Type", new String[]{"application/octet-stream"}).withBody(body).build();
        Assert.assertEquals((Object)expected, (Object)this.aTransformer().apply(response));
    }

    @Test
    public void preservesHeadersExceptThoseSpecificallyExcluded() {
        LoggedResponse response = LoggedResponse.from((Response)Response.response().headers(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Encoding", (String[])new String[]{"gzip"}), HttpHeader.httpHeader((String)"content-LENGTH", (String[])new String[]{"10"}), HttpHeader.httpHeader((String)"transfer-encoding", (String[])new String[]{"chunked"}), HttpHeader.httpHeader((String)"Accept", (String[])new String[]{"application/json"}), HttpHeader.httpHeader((String)"X-foo", (String[])new String[]{"Bar"})})).build());
        ResponseDefinition expected = ResponseDefinitionBuilder.responseDefinition().withHeader("Accept", new String[]{"application/json"}).withHeader("X-foo", new String[]{"Bar"}).build();
        Assert.assertEquals((Object)expected, (Object)this.aTransformer().apply(response));
    }
}

